package handelers

type Flags struct{
	PNG string `json:"png"`
}

// Struktur for data fra REST Countries API
type CountryInfo struct {
	Name struct {
		Common   string         `json:"common"`
		Official string         `json:"official"`
	}                           `json:"name"`
	Capital   []string          `json:"capital"`
	Languages map[string]string `json:"languages"`
	Continents []string          `json:"continents"`
	Borders    []string         `json:"borders"`
	Population int              `json:"population"`
	Flags Flags                `json:"flags"`
}

//type CityInfo struct {
//	Cities []string `json:"cities"`
//}

// Struktur for kombinert respons i info
type CombinedInfo struct {
	Name       string            `json:"name"`
	Continents   []string         `json:"continenents"`
	Population int               `json:"population"`
	Languages  map[string]string `json:"languages"`
	Borders    []string          `json:"borders"`
	Flags      string            `json:"flags"`
	Capital    string            `json:"capital"`
	Cities     string          `json:"cities"`
}

// responsstruktur for befolkningsdata
type PopulationResponse struct {
	Error bool     `json:"error"`
	Msg   string   `json:"msg"`
	Data  []Country `json:"data"`
}

// land og dens befolkningsdata
type Country struct {
	Name             string            `json:"country"`
	Code             string            `json:"iso3"` // Trebokstavskode (ISO 3166-1 alpha-3)
	PopulationCounts []PopulationCount `json:"populationCounts"`
}


// befolkningsdate for et bestemt år (brukes i den endelige repsonsen under values)
type PopulationCount struct {
	Year  int `json:"year"`
	Value int `json:"value"`
}

// Responsstruktur for vårt API(det som vises på skjerm)
type PopulationAPIResponse struct {
	Name           string            `json:"land"`
	Gjennomsnitt   int               `json:"gjennomsnittlig populasjon"`
	Values        []PopulationCount  `json:"årlige populasjoner"`
}