package main

import (
	"fmt"
	"net/http"
	"time"
	"git.gvk.idi.ntnu.no/Mathilde/cloud/handelers"
)

var serviceStartTime time.Time

func main() {
	serviceStartTime = time.Now()

	http.HandleFunc(handelers.STATUS_DEFAULT, func(w http.ResponseWriter, r *http.Request) {
		handelers.DiagnosticsHandler(w, r, serviceStartTime)
	})
	http.HandleFunc(handelers.SLASH_DEFAULT, handelers.HomeHandler)
	http.HandleFunc(handelers.INFO_DEFAULT, handelers.CountryInfoHandler)
	http.HandleFunc(handelers.POPULATION_DEFAULT, handelers.PopulationHandler)


	if err := http.ListenAndServe(":8080", nil); err != nil {
		fmt.Printf("Server failed to start: %s\n", err)
	}
}