package main


import (
    "net/http"
    "assignment1/handlers"
    "time"
)

func main() {
    mux := http.NewServeMux()

    mux.HandleFunc("/librarystats/v1/bookcount/", handlers.BookCountHandler)
    mux.HandleFunc("/librarystats/v1/readership/", handlers.ReadershipHandler)
    mux.HandleFunc("/librarystats/v1/status/", handlers.StatusHandler)

    srv := &http.Server{
        Handler:      mux,
        Addr:         "127.0.0.1:8080",
        WriteTimeout: 15 * time.Second,
        ReadTimeout:  15 * time.Second,
    }

    http.ListenAndServe(":8080", mux)
}
