package handler

import (
	"assignment-1/pkg"
	"encoding/json"
	"github.com/gorilla/mux"
	"log"
	"net/http"
)

// handles requests for /country/
func Chandler(w http.ResponseWriter, r *http.Request) {
	vars := mux.Vars(r)
	limit := r.FormValue("limit") // gets the limit, if specified

	// unnecessary default limit (gbif API has default of 20)
	if len(limit) == 0 {
		limit = "5"
	}

	// gets a country-struct containing data, or error
	country, err := pkg.GetCountryByCode(vars["country_identifier"], limit)

	if err == nil {
		w.Header().Set("Content-Type", "application/json")
		err = json.NewEncoder(w).Encode(&country)
		if err != nil {
			log.Fatal(err)
		}
	} else {
		// need to check error for content when setting header (pkg.CorrectHeader)
		pkg.HttpError(w, err)
	}
}
