package handler

import (
	"assignment-1/pkg"
	"encoding/json"
	"log"
	"net/http"
)

// handles requests for /diag/
func Dhandler(w http.ResponseWriter, r *http.Request) {
	var diagnostics pkg.Diag

	// fills in the diagnostics-var
	err := pkg.GetDiag(&diagnostics)

	// if error was encountered: print error, else: return diagnostics
	if err == nil {
		w.Header().Set("Content-Type", "application/json")
		if err := json.NewEncoder(w).Encode(&diagnostics); err != nil {
			log.Fatal(err)
		}
	} else {
		http.Error(w, err.Error(), http.StatusBadGateway)
	}
}
