package handler

import (
	"assignment-1/pkg"
	"encoding/json"
	"github.com/gorilla/mux"
	"log"
	"net/http"
)

// handles /species/
func Shandler(w http.ResponseWriter, r *http.Request) {
	vars := mux.Vars(r)

	// fills in a species-struct
	specie, err := pkg.GetSpecies(vars["speciesKey"])

	// if no error: print correct json, else: send correct errormessage/header
	if err == nil {
		w.Header().Set("Content-Type", "application/json")
		err = json.NewEncoder(w).Encode(&specie)
		if err != nil {
			log.Fatal(err)
		}
	} else {
		pkg.HttpError(w, err)
	}
}
