package main

import (
	"assignment-1/handler"
	"github.com/gorilla/mux"
	"log"
	"net/http"
	"os"
)

func main() {
	r := mux.NewRouter()

	// sets port
	port := ""
	port = os.Getenv("PORT")
	if port == "" {
		port = "5000"
	}

	// creating a subrouter with a fixed path
	c := r.PathPrefix("/conservation/v1").Methods("GET").Subrouter()

	// two handlerpaths makes sure that the caller does not HAVE to specify limit
	c.Path("/country/{country_identifier:[a-zA-Z][a-zA-Z]}").
		Queries("limit", "{limit}").
		HandlerFunc(handler.Chandler).
		Name("Handel")
	c.Path("/country/{country_identifier:[a-zA-Z][a-zA-Z]}").
		HandlerFunc(handler.Chandler)

	c.Path("/species/{speciesKey}").
		HandlerFunc(handler.Shandler)

	c.Path("/diag/").
		HandlerFunc(handler.Dhandler)

	// makes sure that the router r handles all http-requests
	http.Handle("/", r)
	log.Fatal(http.ListenAndServe(":"+port, nil))
}

