package pkg

const countryApi = "https://restcountries.eu/rest/v2/alpha/"
const occurrenceApi = "http://api.gbif.org/v1/occurrence/search?"

// country struct that will be returned to client
type Country struct {
	Code        string   `json:"code,omitempty"`
	CountryName string   `json:"countryname,omitempty"`
	CountryFlag string   `json:"countryflag,omitempty"`
	Species     []string `json:"species,omitempty"`
	SpeciesKey  []int    `json:"speciesKey,omitempty"`
}

// country struct used for parsing http.response
type tempCountry struct {
	Code string `json:"alpha2code"`
	Flag string `json:"flag"`
	Name string `json:"name"`
}

// struct used to get array of species
type response struct {
	Results []results `json:"results,omitempty"`
}

// array for the creation of species
type results struct {
	Species     string `json:"species,omitempty"`
	SpeciesKey  int    `json:"speciesKey,omitempty"`
}

// returns country information & species based on country-code and limit
func GetCountryByCode(code, limit string) (Country, error) {

	var country Country
	var tmpC tempCountry
	var species response
	urlCountry := countryApi + code

	// gets country info to temp struct
	err := getBody(urlCountry, &tmpC)
	if err != nil {
		return Country{}, err
	}

	// add tmp info to country struct
	country.CountryFlag = tmpC.Flag
	country.CountryName = tmpC.Name
	country.Code        = tmpC.Code   // used to get 2-letter ISO standard code (uppercase)

	urlSpecies := occurrenceApi + "country=" + country.Code + "&limit=" + limit

	// gets species in specified country with limit applied
	err = getBody(urlSpecies, &species)
	if err != nil {
		return Country{}, err
	}

	// adds species-keys & specie-names to the country struct, ensuring no dupes
	check := make(map[results]bool)
	for i, _ := range species.Results {
		// check that species is not already added
		if !check[species.Results[i]] {
			// if any "failed" species exist, exclude them
			if species.Results[i].SpeciesKey != 0 {
				check[species.Results[i]] = true
				country.SpeciesKey = append(country.SpeciesKey, species.Results[i].SpeciesKey)
				country.Species = append(country.Species, species.Results[i].Species)
			}
		}
	}

	return country, nil
}
