package pkg

import (
	"strconv"
	"strings"
	"time"
)

const gbifApi  = "http://api.gbif.org/v1/"
const restApi = "https://restcountries.eu/rest/v2"

// starts counting time since app deployment
var startTime time.Time
func init() {
	startTime = time.Now()
}

// struct for returning requested data
type Diag struct {
	Gbif          string    `json:"gbif,omitempty"`
	Restcountries string    `json:"restcountries,omitempty"`
	Version       string 	`json:"version,omitempty"`
	Uptime        int 		`json:"uptime,omitempty"`
}

// sets up the struct above
func GetDiag(d* Diag) error {

	// gets status of GBIF api, returns appropriate error
	if err := getGbifStatus(d); err != nil{
		// if it was a timeout caused by the http.client
		if strings.Contains(err.Error(), "error occured while contacting") {
			d.Gbif = "503: Request timed out"
		} else {
			return err
		}
	}

	// gets status of restcountries api, returns appropriate error
	if err := getRestStatus(d); err != nil {
		// if it was a timeout caused by the http.client
		if strings.Contains(err.Error(), "error occured while contacting") {
			d.Gbif = "503: Request timed out"
		} else {
			return err
		}
	}

	d.Version = "v1"
	getUptime(d)

	// all went well
	return nil
}

// Gets GBIF-api status code (uses http.client defined in funcs.go)
func getGbifStatus(d *Diag) error {
	resp, err := client.Get(gbifApi)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	d.Gbif = strconv.Itoa(resp.StatusCode)
	return nil
}

// Gets country-api status code (uses http.client defined in funcs.go)
func getRestStatus(d *Diag) error {
	resp, err := client.Get(restApi)
	if err != nil {
		return err
	}
	defer resp.Body.Close()
	d.Restcountries = strconv.Itoa(resp.StatusCode)
	return nil
}

// Returns application uptime in seconds
func getUptime(d *Diag) {
	up := time.Since(startTime).Seconds()
	d.Uptime = int(up)
}