package pkg

const speciesApi = "http://api.gbif.org/v1/species/"

// struct for returning correct json keys
type Specie struct {
	Key 			int 	`json:"key,omitempty"`
	Kingdom 		string 	`json:"kingdom,omitempty"`
	Phylum 			string 	`json:"phylum,omitempty"`
	Order 			string 	`json:"order,omitempty"`
	Family 			string 	`json:"family,omitempty"`
	Genus 			string 	`json:"genus,omitempty"`
	ScientificName 	string 	`json:"scientificName,omitempty"`
	CanonicalName 	string 	`json:"canonicalName,omitempty"`
	Year			string  `json:"year,omitempty"`
}

// gets all relevant species information
func GetSpecies(key string) (Specie, error) {
	var specie Specie
	url := speciesApi + key

	// fills in the body of the specie, returns error & empty specie when appropriate
	err := getBody(url, &specie)
	if err != nil {
		return Specie{}, err
	}

	// supplies the json keys not provided in the first request (year)
	url = url + "/name"

	// using a temp-Specie to only get 'year', not replacing any other variable (just in case of varying info)
	// I interpreted the task as only asking for 'year', not 'bracketYear' as well
	var tempSpecie Specie
	err = getBody(url, &tempSpecie)
	if err != nil {
		return Specie{}, err
	}

	// sets year (if it occurred; has ",omitifempty" in json format)
	specie.Year = tempSpecie.Year

	// all went well
	return specie, nil
}