package projectdb

import (
	"context"
	"go.mongodb.org/mongo-driver/mongo"
	"go.mongodb.org/mongo-driver/mongo/options"
	"log"
)

type DB struct {
	client *mongo.Client
	DBType DBType // Production or Test
}

type ProgramResultData struct {
	InitialInputQuery string
	SolutionCode      string
	CompilerOutput    string
	TestCases         string
}

type ResearchData struct {
	TimeTakenSeconds float64
	Iterations       int
}

const UriDb = "mongodb://localhost:27017"

type DBType string

const (
	Production DBType = "production"
	Test       DBType = "test"
)

// The connection string for the DB database

func (db *DB) WriteDataToDatabase(data ProgramResultData) {

	// Choice of database and collection
	collection := db.client.Database(string(db.DBType)).Collection("data")

	// Inserting a document
	_, err := collection.InsertOne(context.TODO(), data)
	if err != nil {
		log.Fatal(err)
	}
	log.Println("Document inserted")
}

func (db *DB) WriteResearchDataToDatabase(data ResearchData) {

	// Choice of database and collection
	collection := db.client.Database(string(db.DBType)).Collection("research")

	// Inserting a document
	_, err := collection.InsertOne(context.TODO(), data)
	if err != nil {
		log.Fatal(err)
	}
	log.Println("Document inserted")
}

func GetDB(clientOptions *options.ClientOptions, dbType DBType) *DB {
	// Connect to the DB server
	client, err := mongo.Connect(context.TODO(), clientOptions)
	if err != nil {
		log.Fatal(err)
	}

	// test the connection
	err = client.Ping(context.TODO(), nil)
	if err != nil {
		log.Fatal(" DB connection failed:", err)
	}
	log.Println("DB connection successful")

	db := &DB{
		client: client,
		DBType: dbType,
	}

	return db
}

func (db *DB) CloseDB() {
	err := db.client.Disconnect(context.Background())
	if err != nil {
		log.Fatal(err)
	}
}
