package main

import (
	"bufio"
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
	"os"
)

// TODO Check if we can remove this file

const ollamaEndpoint = "http://localhost:11434/api/generate" // The local endpoint for the Ollama API

// Struct for request to Ollama API
type OllamaRequest struct {
	Prompt string `json:"prompt"`
	Model  string `json:"model"`
}

// Struct for response from Ollama API
type OllamaResponse struct {
	Response string `json:"response"`
	Done     bool   `json:"done"`
}

func main() {
	reader := bufio.NewReader(os.Stdin)
	fmt.Print("Enter your prompt: ")
	userPrompt, _ := reader.ReadString('\n')

	// Generate response using Ollama API

	requestBody, err := json.Marshal(OllamaRequest{
		Prompt: userPrompt,
		Model:  "llama3.1",
	})
	if err != nil {
		fmt.Println("Error generating response:", err)
		return
	}

	// Send HTTP POST request to Ollama API
	resp, err := http.Post(ollamaEndpoint, "application/json", bytes.NewBuffer(requestBody))
	if err != nil {
		fmt.Println("Error generating response:", err)
		return
	}
	defer resp.Body.Close()

	// Read and accumulate response body in chunks
	var completeResponse string
	decoder := json.NewDecoder(resp.Body)
	for decoder.More() {
		var chunk OllamaResponse
		if err := decoder.Decode(&chunk); err != nil {
			return
		}
		completeResponse += chunk.Response

		if chunk.Done {
			break
		}
	}

	//fmt.Println("Ollama's response:", completeResponse)
	var out = extract(completeResponse)
	fmt.Println(out)
}

func extract(output string) string {
	var extracted = ""
	var count = 0
	var out = false
	for _, i := range output {
		if i == '`' {
			count++
			if count == 3 {
				if out == true {
					out = false
				} else {
					out = true
				}
				count = 0
			}
		}
		if out == true {
			if i != '`' {
				extracted += string(i)
			}
		}
	}
	return extracted
}
