package program

import (
	"context"
	"go.mongodb.org/mongo-driver/mongo/options"
	projectdb "llama/database"
	"llama/modules/compiler_v2/go_compiler_v2"
	"llama/modules/extraction"
	ollamaimplementation "llama/modules/ollama-implementation"
	"testing"
	"time"
)

type NoUI struct{}

// WriteJSON A mock implementation when there are no UI elements
func (n *NoUI) WriteJSON(_ any) error {
	return nil
}

func GetOllamaGoProgramNoUI() Program {
	clientOptions := options.Client().ApplyURI(projectdb.UriDb)
	db := projectdb.GetDB(clientOptions, projectdb.Production)

	languageModel := &ollamaimplementation.Ollama{Model: "llama3.1"}

	compiler := go_compiler_v2.GoCompiler{}.CheckCompileErrors
	extractor := &extraction.GoExtractor{}
	prog := Program{
		LanguageModel: languageModel,
		Ctx:           context.Background(),
		UI:            &NoUI{},
		DB:            db,
		Compiler:      compiler,
		Extractor:     extractor,
	}

	return prog
}

func TestProgram_Run_WithLlama3_1_AndGolang(t *testing.T) {

	prog := GetOllamaGoProgramNoUI()

	prog.Run("write a code that adds two numbers", extraction.GoPrompt)
}

func TestProgram_RunIteration_with_FirstIterationHavingBugInCode(t *testing.T) {
	prog := GetOllamaGoProgramNoUI()

	prog.RunIteration(
		"write a code that adds two numbers",
		"write a code that adds two numbers",
		extraction.GoPrompt,
		[]int{},
		2,
		time.Now(),
	)
}
