package main

import (
	"bufio"
	"bytes"
	"encoding/json"
	"fmt"
	"net/http"
	"os"
	"strings"
)

const ollamaEndpoint = "http://localhost:11434/api/generate" // The local endpoint for the Ollama API

// Struct for request to Ollama API
type OllamaRequest struct {
	Prompt string `json:"prompt"`
	Model  string `json:"model"`
}

// Struct for response from Ollama API
type OllamaResponse struct {
	Response string `json:"response"`
	Done     bool   `json:"done"`
}

func main() {
	reader := bufio.NewReader(os.Stdin)
	fmt.Print("Enter your prompt: ")
	userPrompt, _ := reader.ReadString('\n')

	//Modifying the user prompt to make the code in rust or gloang, will always be rust so far
	var userPromptModified string
	if true {
		userPromptModified = userPrompt + "and make the code in rust"
	} else {
		userPromptModified = userPrompt + "and make the code in golang"
	}
	fmt.Println(userPromptModified)

	// Generate response using Ollama API

	requestBody, err := json.Marshal(OllamaRequest{
		Prompt: userPromptModified,
		Model:  "llama3.1",
	})
	if err != nil {
		fmt.Println("Error generating response:", err)
		return
	}

	// Send HTTP POST request to Ollama APIÍ
	resp, err := http.Post(ollamaEndpoint, "application/json", bytes.NewBuffer(requestBody))
	if err != nil {
		fmt.Println("Error generating response:", err)
		return
	}
	defer resp.Body.Close()

	// Read and accumulate response body in chunks
	var completeResponse string
	decoder := json.NewDecoder(resp.Body)
	for decoder.More() {
		var chunk OllamaResponse
		if err := decoder.Decode(&chunk); err != nil {
			return
		}
		completeResponse += chunk.Response

		if chunk.Done {
			break
		}
	}

	fmt.Println("Ollama's response:", completeResponse)
	// var out = extract(completeResponse)
	// fmt.Println(out)
}

// Extracting strings from everthing between ```
// Will be used once we decide how to get rid of explanations with the code.
func extract(output string) string {
	parts := strings.Split(output, "```")
	var extracted = ""
	if strings.Contains(parts[1], "rust") {
		extracted = strings.TrimLeft(parts[1], "rust")
	} else {
		extracted = strings.TrimLeft(parts[1], "go")
	}
	return extracted
}
