package no.ntnu.idatg2001;

import java.util.ArrayList;
import java.util.List;

public class HandOfCards {

    private ArrayList<PlayingCard> cards;

    public HandOfCards(ArrayList cards) {
        this.cards = cards;
    }

    public int getHandSize() {
        return cards.size();
    }

    public int sumOfCards() {
        return cards.stream().map(playingCard -> playingCard.getFace()).reduce(0, (total, face) -> total + face);
    }

    public String getCardsOfHeart() {
        return cards.stream()
                .filter(playingCard -> playingCard.getSuit()=='H')
                .map(playingCard -> playingCard.getAsString())
                .reduce("No Hearts", (total, string) -> string);
    }

    public boolean checkQueenOfSpades() {
        return cards.stream().anyMatch(playingCard -> playingCard.getAsString().equals("S12"));
    }

    public boolean checkForFlush() {
        return cards.stream().allMatch(playingCard -> playingCard.getSuit()=='S');
    }


}
