package main

import (
	"fmt"
	"html"
	"log"
	"net/http"
	"os"
)

//Server that prints halli

func helloHandler(w http.ResponseWriter, r *http.Request) {
	fmt.Fprintf(w, "Hello, %q", html.EscapeString(r.URL.Path))
}

func main() {
	port := os.Getenv("PORT")
	port = "8080"

	if port == "" {
		log.Fatal("$PORT must be set")
	}

	http.HandleFunc("/", helloHandler)

	log.Fatal(http.ListenAndServe(":"+port, nil))
}
