package com.example.horcon.lab1;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.Spinner;

/**
 * Main activity, sends to A2
 */
public class A1Main extends AppCompatActivity {
    public static final String EXTRA_MESSAGE = "com.example.myfirstapp.MESSAGE";
    private static String[] items = {"test1", "test2", "test3"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_a1__main);

        //Set up the spinner with text strings
        Spinner spinner = findViewById(R.id.L1);
        ArrayAdapter<String> adapter;
        adapter = new ArrayAdapter<>(this,
                android.R.layout.simple_spinner_item, items);
        spinner.setAdapter(adapter);

        //Get preferences, set spinner to saved position, with position 1 as default
        final SharedPreferences sharedPreferences = getPreferences(Context.MODE_PRIVATE);
        spinner.setSelection(sharedPreferences.getInt("SelectedSpinner", 1));

        //On spinner click
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> adapterView, View view, int pos, long id) {
                //Get preferences editor, set spinner position to its new position
                SharedPreferences.Editor editor = sharedPreferences.edit();
                editor.putInt("SelectedSpinner", pos);
                editor.commit();
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
    }

    /**
     * Starts activity A2, sends message in T1
     * @param view
     */
    public void sendMessage(View view) {
        //Get message
        EditText t1 = findViewById(R.id.T1);
        String message = t1.getText().toString();

        //Create intent, save message in intent, start A2
        Intent intent = new Intent(this, A2.class);
        intent.putExtra(EXTRA_MESSAGE, message);
        startActivity(intent);
    }
}
