package com.example.horcon.lab1;

import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.TextView;

/**
 * Activity A2, can send users to A3
 */
public class A2 extends AppCompatActivity {
    private static final int CALL_A3 = 3;
    public static final String EXTRA_MESSAGE = "com.example.myfirstapp.MESSAGE";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_a2);

        // Get the Intent that started this activity and extract the string
        Intent intent = getIntent();
        String message = intent.getStringExtra(A1Main.EXTRA_MESSAGE);

        // Capture the layout's TextView and set the string as its text
        TextView textView = findViewById(R.id.T2);
        textView.setText("Hello " + message);
    }

    /**
     * Start activity A3, expecting a result from it
     * @param view
     */
    public void toA3(View view) {
        Intent intent = new Intent(this, A3.class);
        startActivityForResult(intent, CALL_A3);
    }

    /**
     * Process response from A3
     * @param requestCode Request code given to A3
     * @param resultCode Result of the operation, ie. RESULT_OK
     * @param data Intent data with message
     */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        //If the request is for A3, and result is OK
        if (requestCode == CALL_A3) {
            if (resultCode == RESULT_OK) {
                //Get message from intent
                String message = data.getStringExtra(EXTRA_MESSAGE);

                //Set textview for A3 message (T3) to message
                TextView textView = findViewById(R.id.T3);
                textView.setText("From A3: " + message);
            } else {
                //If the result was not OK, say nothing was received from A3
                TextView textView = findViewById(R.id.T3);
                textView.setText("Nothing from A3!");
            }
        }
    }


}
