from typing import Type
from flask import request
from pkg_resources import invalid_marker
#from flask_cors import cross_origin
from app import app

import app.Const as Const

import app.Controller.ProjectController as project

from app import Error

from orchestrationLogic.orchestrator import *

@app.route('/', methods = ['GET'])
def home():
   return ":)"


@app.route('/api/new-project', methods = ['POST'])
#@cross_origin()
def newProjectEndpoint():
   requestData = request.get_json() # JSON data
   
   if(requestData): ## Theres json in req. body
      emailsOfUsers = requestData.get('users') ## Email of clients
      ownerMail = requestData.get('owner')
      publicKey = requestData.get('publicKey')
      if(emailsOfUsers and ownerMail and publicKey): # Make sure 'users' exists. 
         try:
            return project.newProject(emailsOfUsers, ownerMail, publicKey), Const.HTTPOK
         except Error.OutOfRangeError as err:
            return err.message, Const.HTTPBADREQUEST
         except (Error.InvalidEmailError, Error.InvalidUsernameError, Error.InvalidPublicKeylError) as err:
            return err.message, Const.HTTPBADREQUEST
         except (TypeError, ValueError) as err:
            return str(err), Const.HTTPBADREQUEST
         except Error.ProjectCreateFailedError as err:
            return err.message, Const.HTTPINTERNALERROR
         except Exception as err:
            return str(err), Const.HTTPINTERNALERROR

      else: 
         return "Missing parameters", Const.HTTPBADREQUEST
   else:
      return "Missing body", Const.HTTPBADREQUEST
   

@app.route('/api/project/<name>', methods = ['DELETE'])
def deleteProjectEndpoint(name):
   if (name):
      try:
         return project.deleteProject(name), Const.HTTPOK
      except Error.ProjectDeleteFailedError as err:
         return err.message, Const.HTTPINTERNALERROR
      except Exception as err:
         return Const.HTTPINTERNALERROR

   return Const.HTTPBADREQUEST

@app.route('/api/project/<name>', methods = ['GET'])
def getIPEndpoint(name):
   if (name):
      try:
         return project.getIP(name) , Const.HTTPOK
      except Error.ProjectNotFoundError as err:
         return err.message, Const.HTTPNOTFOUND
      except Exception as err:
         return Const.HTTPINTERNALERROR

   return Const.HTTPBADREQUEST
