import re
import string

###
# Validate email.
###
def validateEmail(email):
    regex = r'\b[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\.[A-Z|a-z]{2,}\b' #https://www.geeksforgeeks.org/check-if-email-address-valid-or-not-in-python/
    if(re.fullmatch(regex, email)):
        return True
    return False

def getUserNameFromEmail(email):
    username = email.rpartition('@')[0].lower()
    return username


def validateUsername(username):
    return username.isalpha() and len(username) < 10

def validatePublicKey(publicKey):
    for c in publicKey:
        if not ( c.isalnum() or c in {' ', '@', '+', '/', '.', '=', '-'}):
            return False
    
    return True
