from flask import Flask, request
from celery import Celery
from secrets import token_hex

app = Flask(__name__)
app.secret_key = token_hex() # Secret key for sessions


# Informs celery of the broker
app.config['CELERY_BROKER_URL'] = 'redis://redis:6379/0'
celery = Celery(app.name, broker=app.config['CELERY_BROKER_URL'])


# enables message signing for celery
celery.conf.update(
    security_key='/ssl/private/worker.key',
    security_certificate='/ssl/cert/worker.crt',
    security_cert_store='/ssl/cert/*.crt',
    security_digest='sha256',
    task_serializer='auth',
    event_serializer='auth',
    accept_content=['auth']
)
celery.setup_security()

from app.Controller import ProjectController
from app import Const, Routes
