#!/bin/bash
#sed -i -r 's/STATDOPTS=.*/STATDOPTS="--port 32765 --outgoing-port 32766"/' /etc/default/nfs-common
#sed -i -r 's/RPCMOUNTDOPTS=.*/RPCMOUNTDOPTS="-p 32767"/' /etc/default/nfs-kernel-server
#apt-get install samba
# Lager samba passord
#sambapassword=$(/usr/bin/pwgen -s -1 32)
sambapassword=""
# wc_notify --data-binary "{\"status\": \"SUCCESS\", \"id\": \"password\", \"data\": \"${sambapassword}\"}"
(echo $sambapassword; echo $sambapassword) | smbpasswd -a ubuntu -s
# DISK mounting
echo "/dev/vdb1	/opt/data	ext4	defaults,comment=cloudconfig	0	0" >> \
    /etc/fstab
#sudo cat /etc/samba/smb.conf >> /usr/share/samba/smb.conf
#cp /usr/share/samba/smb.conf /etc/samba/smb.conf
mkdir /opt/data
mount /dev/vdb1 /opt/data
mkdir /opt/data/shared

# this directory should be owned by root for security reasons
# http://lists.mindrot.org/pipermail/openssh-unix-dev/2009-May/027651.html
chown root:root /opt/data
chmod 755 /opt/data


# Everything below is based on the great top answer for this stack exchange question
# https://unix.stackexchange.com/questions/503312/is-it-possible-to-grant-users-sftp-access-without-shell-access-if-yes-how-is-i
# adds two groups one fro users who are allowed to ssh (ubuntu) and one 
# for user who are only allowed to sftp 
addgroup --system allowssh
addgroup --system sftponly

chown <owern>:allowssh /opt/data/shared
chmod 775 /opt/data

sudo service smbd restart

# creates a user with no no password
# /sbin/nologin is not needed but is done just to be safe
adduser --disabled-password --gecos "" --home /home/project_owner <owner>

# owner can have access to /opt/shared to upload and download files
chown ubuntu /opt/data/shared

mkdir /home/project_owner/.ssh/
touch /home/project_owner/.ssh/authorized_keys
echo '<publicKey>' > /home/project_owner/.ssh/authorized_keys

adduser <owner> allowssh
adduser <owner> sftponly

adduser ubuntu allowssh



echo 'PermitRootLogin no
PubkeyAuthentication no
PasswordAuthentication no
ChallengeResponseAuthentication no
UsePAM yes
X11Forwarding yes
PrintMotd no
AcceptEnv LANG LC_*
Subsystem   sftp    /usr/lib/openssh/sftp-server

# all users need to be in this group to ssh or sftp
# only pubic key authentication is allowed
Match Group allowssh
    PubkeyAuthentication yes

# users who are only allowed to ssh is added to this group aswel
# Croot keeps them form accessing anything outside /opt/data
# disables forwarding and only allows sftp
Match Group sftponly
    ChrootDirectory /opt/data
    DisableForwarding yes
    ForceCommand internal-sftp' > /etc/ssh/sshd_config


# restart ssh to apply changes
sudo systemctl restart ssh.service
