window.onload = function() {
    
    $(".progress-bar").animate({
        width: "99%"
    }, 15000);
   
    setTimeout(getIP, 15000)
  };


function getIP() {
    const urlSearchParams = new URLSearchParams(window.location.search);
    const params = Object.fromEntries(urlSearchParams.entries());

    var projectName = params.project;
    var owner = params.owner.split("@")[0]  

    const address = new XMLHttpRequest();
    const url = "http://10.212.140.0:8080/api/project/" + projectName;
    address.open("GET", url, true);
    address.send();

    address.onload = function() {
        //samme her
        if(address.readyState === 4 && address.status === 200){

            $(".progress-bar").animate({
                width: "100%"
            }, 1500);
        


            document.getElementById('your-project').innerHTML = `Your project is "${projectName}" and it's ip is ${address.responseText}`;            

            document.getElementById('ready-project').innerHTML =
            `
            <p class="lead">Please wait for atleast 15 minutes before attempting to connect to windows clients</p>
            <hr class="my-4">
            <p>In about 5 miniutes you should be able to upload files to your fileserver</p>
            <p>To do this you can follow <a href="https://wiki.filezilla-project.org/Howto" class="link-primary" target="_blank">this</a> guide on how to use Filezilla with key based authentication</p>

            <p>Or if you prefer you open a shell inside the folder containing files you wish to upload, then use the command below to start a SFTP session</p>
            <code>sftp -i /path/to/your/private_key ${owner}@${address.responseText}:/shared</code>
            <p>You now be able to upload files using <code>put filename</code> and download files using <code>get filename</code></p>
            

            <a class="row btn btn-danger btn-lg" href="#" role="button" onclick="deleteProject()" id="delete-button">Delete Project</a>
            
            `

        } else {
            document.getElementById('your-project').innerHTML = 
            `<div class="alert alert-danger" role="alert">
                <p class="lead">Could not fetch the IP of your project</p>
            </div> 
            <button type="button" class="btn btn-light"  onclick='getIP()'>Try Again</button>`;
        }

    }
}

function deleteProject() {

    document.getElementById('delete-button').innerHTML = 
    `
    <span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>
    <span class="sr-only">Loading...</span>
    Loading....
    `

    const urlSearchParams = new URLSearchParams(window.location.search);
    const params = Object.fromEntries(urlSearchParams.entries());

    var projectName = params.project;  

    const remove_project = new XMLHttpRequest();
    //delete_name = delete_name.slice(1);
    //delete_name = delete_name.slice(0, delete_name.length - 1);
    const url = "http://10.212.140.0:8080/api/project/" + projectName;
    remove_project.open("DELETE", url, true);
    remove_project.send();

    remove_project.onload = function() {
        document.getElementById('delete-button').innerHTML = 
        `
            Delete Project
        `



        if(remove_project.readyState === 4 && remove_project.status === 200){
            document.getElementById('alert-div').innerHTML = 
            `
            <div class="alert alert-success" role="alert">
                <p class="lead">Project was successfully deleted</p>
            </div>`;

        } else {
            document.getElementById('alert-div').innerHTML = 
            `
            <div class="alert alert-danger" role="alert">
                <p class="lead">Project deletion failed</p>
            </div>`;
        }

    }
}
