from errno import EROFS
from app import celery
from app import Error
import app.Util as Util


from orchestrationLogic.orchestrator import *


@celery.task
def comfirmProject(nameOrID):
    orchestrator = Orchestrator()
    orchestrator.ensureProjectCreation(nameOrID)

@celery.task
def comfirmDeletion(nameOrID):
    orchestrator = Orchestrator()
    return orchestrator.ensureProjectDeletion(nameOrID)

def newProject(userMails, ownerMail, publicKey):
    
    initialUsers = []

    for mail in userMails:
        if not Util.validateEmail(mail):
            raise Error.InvalidEmailError(mail)

    if not Util.validateEmail(ownerMail):       # Make sure that the ownermail 
        raise Error.InvalidEmailError(ownerMail)

    owner = Util.getUserNameFromEmail(ownerMail)    
    if not Util.validateUsername(owner):
        raise Error.InvalidUsernameError(owner)

    if not Util.validatePublicKey(publicKey):
        raise Error.InvalidPublicKeylError()
    
    orchestrator = Orchestrator()
    name = orchestrator.createProject(userMails, owner, publicKey)

    if name:
        comfirmProject.delay(name)
        return name
    else:
        raise Error.ProjectCreateFailedError



def getIP(nameOrID):
    orchestrator = Orchestrator()
    IP = orchestrator.getLBIP(nameOrID)

    if IP:
        return IP
    else:
        raise Error.ProjectNotFoundError

# Delete a project if the name match the name of a project.
def deleteProject(nameOrId):
    orchestrator = Orchestrator()
    nameOrId = str(nameOrId)
    
    if orchestrator.deleteProject(nameOrId):
        comfirmDeletion.delay(nameOrId)
        return "Project Deleted"
    else:
        raise Error.ProjectDeleteFailedError



