package main

import (
	"fmt"
	"log"
	"net/http"
	"os"
	"assignment1"
)

func handlerNil(w http.ResponseWriter, r *http.Request) {
	fmt.Println("Default Handler: Invalid request received.")
	http.Error(w, "Invalid request", http.StatusBadRequest)
}

// -----------------


func main() {
	port := os.Getenv("PORT")
	if port == "" {
		port = "8080"
	}
	assignment1.InitStartTime()
	http.HandleFunc("/", handlerNil)
	http.HandleFunc("/conservation/" + assignment1.Version + "/country/", assignment1.HandlerCountry)
	http.HandleFunc("/conservation/" + assignment1.Version + "/species/", assignment1.HandlerSpecies)
	http.HandleFunc("/conservation/" + assignment1.Version + "/diag/", assignment1.HandlerDiagnostics)
	fmt.Println("Listening on port " + port)
	log.Fatal(http.ListenAndServe(":" + port, nil))
}
