package assignment1

import (
	"encoding/json"
	"fmt"
	"log"
	"net/http"
	"strings"
)
const Version string = "v1"
const DefaltLimit string = "20"


func HandlerCountry(w http.ResponseWriter, r *http.Request) {
	country := &Country{}
	gCountry := &GbifCountry{}
	res := &CountryReturn{}
	http.Header.Add(w.Header(), "content-type", "application/json")
	parts := strings.Split(r.URL.Path, "/")
	// 5 is output when checking len(parts) of url that should work
	if len(parts) != 5 || parts[1] != "conservation" || parts[2] != Version || parts[3] != "country" || parts[4] == "" {
		http.Error(w, "Malformed URL", http.StatusBadRequest)
		return
	} else {
		q := r.URL.Query()
		// Queries occurrence API
		replyWithOccurrence(w, gCountry, parts[4], q["limit"])
		// Queries Country API
		replyWithCountry(w, country, parts[4])
		// Creates common struct for both results
		join(res, gCountry, country)
		// Returns output to client
		json.NewEncoder(w).Encode(res)

	}
}

// Populate res CountryReturn with gCountry and country
func join(res *CountryReturn, gCountry *GbifCountry, country *Country) {
	// Pupulating res struct
	res.Alpha2Code = country.Alpha2Code
	res.Flag = country.Flag
	res.Name = country.Name
	for _, v := range gCountry.Results{
		res.SpeciesKey = append(res.SpeciesKey, v.SpeciesKey)
		res.Species = append(res.Species, v.Species)
	}
}

func replyWithCountry(w http.ResponseWriter, country *Country, code string) {
	apiurl := "https://restcountries.eu/rest/v2/alpha/"
	apiurl += code
	// Request apiURL
	req, err := http.NewRequest(http.MethodGet, apiurl, nil)
	if err != nil {
		log.Fatal(err)
	}
	client := http.DefaultClient
	resp, err := client.Do(req)
	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()
	// Decode response into country struct
	json.NewDecoder(resp.Body).Decode(&country)
	// Check if struct contains actual data
	if (*country).Alpha2Code == ""{
		http.Error(w, "Incorrect Alpha2Code", http.StatusBadRequest)
	}else{
		// Printing output to console
		fmt.Println("Country Working")
	}
}
