package assignment1

import (
	"encoding/json"
	"log"
	"net/http"
	"strings"
	"time"
)

func HandlerDiagnostics(w http.ResponseWriter, r *http.Request) {
	http.Header.Add(w.Header(), "content-type", "application/json")
	parts := strings.Split(r.URL.Path, "/")
	// If no errors, run reply func
	if len(parts) != 5 || parts[1] != "conservation" || parts[2] != Version || parts[3] != "diag" {
		http.Error(w, "Malformed URL", http.StatusBadRequest)
		return
	} else {
		replyWithDiag(w)
	}
}

// Func creates diagnostics struct and populates json structure
func replyWithDiag(w http.ResponseWriter) {
	diag := Diagnostics{}
	// First gbif, then restcountries
	urls := [2]string{"http://api.gbif.org/v1/species/", "https://restcountries.eu/rest/v2"}
	for i, url := range urls {
		req, err := http.Get(url)
		// If there are errors requesting page
		if err != nil {
			log.Println("Error:", err)
		}
		if i == 0{
			// When i == 0, its the first iteration of the loop which means it's gbif's query
			diag.Gbif = req.StatusCode
		}else {
			// When it's not 0 it is the second url which is restcountries
			diag.Restcountries = req.StatusCode
		}
	}
	diag.Version = Version
	// Uptime is in seconds
	diag.Uptime = timeRunning()
	// Return json structure to client
	json.NewEncoder(w).Encode(diag)
}

// Time variable
var startTime time.Time

func timeRunning() float64 {
	//return time.Since(startTime)
	s := time.Since(startTime)
	// Return application uptime in seconds
	return s.Seconds()
}

func InitStartTime() {
	startTime = time.Now()
}
