package assignment1

import (
	"encoding/json"
	"fmt"
	"log"
	"net/http"
)

func replyWithOccurrence(w http.ResponseWriter, gCountry *GbifCountry, code string, q []string) {
	apiurl := "http://api.gbif.org/v1/occurrence/search?country="
	apiurl += code
	// Chekcs if a limit is set
	if len(q) > 0 {
		// If limit set, use user provided limit
		apiurl += "&limit=" + q[0]
	}else {
		// If no limit set, use default limit (20)
		apiurl += "&limit=" + DefaltLimit
	}
	req, err := http.NewRequest(http.MethodGet, apiurl, nil)
	if err != nil {
		log.Fatal(err)
	}
	client := http.DefaultClient
	resp, err := client.Do(req)
	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()
	err = json.NewDecoder(resp.Body).Decode(&gCountry)
	if err != nil {
		panic(err)
	}

	if (*gCountry).Count == 0{
		http.Error(w, "Incorrect Name", http.StatusBadRequest)
	}else{
		// Print output to console
		fmt.Println("Occurrence Working")
	}
}
