package assignment1

import (
	"encoding/json"
	"log"
	"net/http"
	"strings"
)

// Handle species
func HandlerSpecies(w http.ResponseWriter, r *http.Request){
	http.Header.Add(w.Header(), "content-type", "application/json")
	parts := strings.Split(r.URL.Path, "/")
	if len(parts) != 5 || parts[1] != "conservation" || parts[2] != Version || parts[3] != "species" || parts[4] == "" {
		http.Error(w, "Malformed URL", http.StatusBadRequest)
		return
	} else {
		replyWithSpecies(w, parts[4])
	}
}

// Query for species
func replyWithSpecies(w http.ResponseWriter, code string) {
	spec := &Species{}
	apiurl := "http://api.gbif.org/v1/species/"
	apiurl += code
	req, err := http.NewRequest(http.MethodGet, apiurl, nil)
	if err != nil {
		log.Fatal(err)
	}
	client := http.DefaultClient
	resp, err := client.Do(req)
	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()
	json.NewDecoder(resp.Body).Decode(&spec)
	// Check if struct contains actual data
	if spec.ScientificName == "" {
		http.Error(w, "Incorrect Name\n", http.StatusBadRequest)
	} else {
		// Call func that calls /name to get year
		replyWithYear(spec, apiurl)
		// Return json data to client
		json.NewEncoder(w).Encode(spec)
	}
}
// Func
// Init new struct
// Copy year from new struct to original struct
func replyWithYear(spec *Species, url string){
	newSpec := &SpeciesYear{}
	apiurl := url + "/name"
	req, err := http.NewRequest(http.MethodGet, apiurl, nil)
	if err != nil {
		log.Fatal(err)
	}
	client := http.DefaultClient
	resp, err := client.Do(req)
	if err != nil {
		panic(err)
	}
	defer resp.Body.Close()
	json.NewDecoder(resp.Body).Decode(&newSpec)
	// No error check for bracketYear, since it can be empty
	spec.Year = newSpec.BracketYear
}