package assignment1

//
// This file contains all the structs for the assignment1 module
//

// Struct for species
type Species struct {
	Key            int    `json:"key"`
	Kingdom        string `json:"kingdom"`
	Phylum         string `json:"phylum"`
	Order          string `json:"order"`
	Family         string `json:"family"`
	Genus          string `json:"genus"`
	Species        string `json:"species"`
	ScientificName string `json:"scientificName"`
	CanonicalName  string `json:"canonicalName"`
	Year           string `json:"year"`
}

// Struct to get year
type SpeciesYear struct {
	BracketYear string `json:"bracketYear"`
}

// Diagnostics struct
type Diagnostics struct {
	Gbif          int     		`json:"gbif"`
	Restcountries int 			`json:"restcountries"`
	Version       string        `json:"version"`
	// Uptime is in seconds
	Uptime        float64       `json:"uptime"`
}

// Country struct
type Country struct {
	Alpha2Code string `json:"alpha2Code"`
	Name       string `json:"name"`
	Flag       string `json:"flag"`
}

// Gbif occurrence struct
type GbifCountry struct {
	Count int `json:"count"`
	Results []Results
}
// Results list from gbif country
type Results struct {
	SpeciesKey int `json:"speciesKey"`
	Species string `json:"species"`
}

// Struct to return full country struct
type CountryReturn struct {
	Country
	Species    []string `json:"species"`
	SpeciesKey []int `json:"speciesKey"`
}
