package com.application;

import com.application.DB.DB;
import javafx.application.Application;

import javafx.scene.chart.LineChart;

import javafx.scene.control.MenuBar;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.*;
import javafx.scene.Scene;
import javafx.stage.Stage;


import javafx.scene.chart.CategoryAxis;

import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;


import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.*;

/**
 * This class launches the application
 *
 * @author Eilert Tunheim, Karin Pettersen, Mads Arnesen
 * @version 1.0.0
 */
public class Main extends Application {

    private BorderPane topBar;
    private HBox menuBar;
    private HBox logoBar;
    private VBox sideBar;
    private LineChart<String, Number> lineChart;
    private MenuBar menubar2;

    /**
     * Starts the application
     * @param args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        launch(args);
    }

    /**
     * Initializes the application with all the different panes.
     *
     * @throws Exception Exception in super.
     */
    @Override
    public void init() throws Exception {
        super.init();

        // Initializing variables
        this.topBar = new BorderPane();
        this.menuBar = new HBox();
        this.logoBar = new HBox();
        this.sideBar = new VBox();
        this.menubar2 = new MenuBar();
    }

    /**
     * Sets the primaryStage and sets the scene for the window.
     * @param primaryStage
     * @throws Exception
     */
    @Override
    public void start(Stage primaryStage) throws Exception {

        // Create panes for root
        BorderPane root = new BorderPane();
        this.menuBar = createMenuBar();
        this.logoBar = createLogoBar();
        this.lineChart = createLineChart();

        //Set id's to connect to css stylesheet
        root.setId("root");
        this.logoBar.setId("logoBar");
        this.menuBar.setId("menuBar");
        this.sideBar.setId("sideBar");
        this.lineChart.setId("lineChart");

        // Sets alignment for the topBar
        this.topBar.setTop(menuBar);
        this.topBar.setCenter(logoBar);

        // Sets alignment for the panes to the parent root
        root.setTop(this.topBar);
        root.setLeft(this.sideBar);
        root.setCenter(this.lineChart);

        VBox.setVgrow(this.logoBar, Priority.ALWAYS);

        // Sets the scene and defines boundaries
        //Scene scene = new Scene(root, 1200, 600);
        Scene scene = new Scene(root, 1200, 600);
        scene.getStylesheets().add(getClass().getResource("/com.application/styleSheet.css").toExternalForm());

        primaryStage.setTitle("Moelven Drying Application");
        //primaryStage.setMaximized(true);
        primaryStage.setMinHeight(600);
        primaryStage.setMinWidth(1200);
        primaryStage.setScene(scene);
        primaryStage.show();
    }

    /**
     * Creates the menubar with buttons.
     * Defines each action when button is clicked.
     *
     * @return MenuBar as a HBox
     */
    private HBox createMenuBar() {
        // Creating buttons for menubar
        ToggleGroup btnMenuGroup = new ToggleGroup();
        ToggleButton btnMenuHome = new ToggleButton("Home");
        ToggleButton btnMenuInput = new ToggleButton("Input");
        ToggleButton btnMenuFinish = new ToggleButton("Finish");
        ToggleButton btnMenuHelp = new ToggleButton("Help");


        // Set the buttons toggleable
        btnMenuHome.setToggleGroup(btnMenuGroup);
        btnMenuInput.setToggleGroup(btnMenuGroup);
        btnMenuFinish.setToggleGroup(btnMenuGroup);
        btnMenuHelp.setToggleGroup(btnMenuGroup);

        // Set the home button as default selected
        btnMenuHome.setSelected(true);

        //Make sure always one button is selected
        btnMenuGroup.selectedToggleProperty().addListener((obsVal, oldVal, newVal) -> {
            if (newVal == null)
                oldVal.setSelected(true);
        });

        /*
        btnMenuMetaImage.setOnAction(e -> featurePane.loadMetaImage());
        btnMenuImport.setOnAction(e -> featurePane.loadImport());
        btnMenuCreate.setOnAction(e -> featurePane.loadCreate());
        btnMenuSearch.setOnAction(e -> featurePane.loadSearch());
         */

        menuBar.getChildren().addAll(btnMenuHome, btnMenuInput, btnMenuFinish, btnMenuHelp);
        return menuBar;
    }


    /**
     * This function imports the logos and defines the alignments
     * @return a logoBar containing the logos in proper alignments
     * @throws FileNotFoundException
     */
    private HBox createLogoBar() throws FileNotFoundException {
        // Defining the image paths
        Image moelvenLogoM = new Image(new FileInputStream("src/main/resources/com.application/GUI/moelven_logo_m.jpg"));
        Image moelvenLogoTitle = new Image(new FileInputStream("src/main/resources/com.application/GUI/moelven_logo_title.jpg"));

        // Creating imageview objects
        ImageView imageViewM = new ImageView(moelvenLogoM);
        ImageView imageViewTitle = new ImageView(moelvenLogoTitle);

        // Defining resolution and aspect ratio
        imageViewM.setFitHeight(100);
        imageViewM.setPreserveRatio(true);
        imageViewTitle.setFitHeight(100);
        imageViewTitle.setPreserveRatio(true);

        // Defining alignments
        Region region1 = new Region();
        HBox.setHgrow(region1, Priority.ALWAYS);

        Region region2 = new Region();
        HBox.setHgrow(region2, Priority.ALWAYS);

        return new HBox(imageViewM, region1, imageViewTitle, region2);
    }


    private LineChart<String,Number> createLineChart() throws Exception {

        final CategoryAxis xAxis = new CategoryAxis();
        final NumberAxis yAxis = new NumberAxis();
        xAxis.setLabel("Date");

        final LineChart<String, Number> lineChart =
                new LineChart<>(xAxis, yAxis);

        lineChart.setTitle("Drying Process");

        Map<String, Number> map = DB.getKwh();
        Map<String, Number> treeMap = new TreeMap<>(map);

        XYChart.Series series1 = new XYChart.Series();
        series1.setName("Drying 1");
        treeMap.forEach((key, value) -> series1.getData().add(new XYChart.Data(key,value)));

        lineChart.getData().add(series1);
        return lineChart;
    }

}

