package com.application.GUI;

import javafx.geometry.Pos;
import javafx.scene.*;
import javafx.scene.control.*;
import javafx.scene.layout.*;
import javafx.stage.*;

import static com.application.DB.Constants.*;
import com.application.Main;

/**
 * This class handles the popup input window
 *
 * @author Eilert Tunheim, Karin Pettersen, Mads Arnesen
 * @version 1.0
 */
public class InputPopUpWindow {

    public static void display()
    {
        Stage window = new Stage();

        window.initModality(Modality.APPLICATION_MODAL);
        window.setTitle("Input Parameters");

        // Top
        Label inputLabel= new Label("Input");
        inputLabel.setId("inputTop");

        // Center - Input fields
        // Tree species
        Label treeSpeciesInputLabel = new Label("Tree Species");
        treeSpeciesInputLabel.setId("inputLabel");
        TextField treeSpeciesInputText = new TextField();
        treeSpeciesInputText.setId("inputLabelText");
        treeSpeciesInputText.setPromptText("Bjørk");
        treeSpeciesInputText.getText();

        // Width
        Label widthInputLabel = new Label("Width");
        widthInputLabel.setId("inputLabel");
        TextField widthInputText = new TextField();
        widthInputText.setId("inputLabelText");
        widthInputText.setPromptText("47");

        // Height
        Label heightInputLabel = new Label("Height");
        heightInputLabel.setId("inputLabel");
        TextField heightInputText = new TextField();
        heightInputText.setId("inputLabelText");
        heightInputText.setPromptText("200");

        // Sawset
        Label sawsetInputLabel = new Label("Sawset");
        sawsetInputLabel.setId("inputLabel");
        TextField sawsetInputText = new TextField();
        sawsetInputText.setId("inputLabelText");
        sawsetInputText.setPromptText("4x");

        // Moisture
        Label moistureGoalInputLabel = new Label("Moisture Goal");
        moistureGoalInputLabel.setId("inputLabel");
        TextField moistureGoalInputText = new TextField();
        moistureGoalInputText.setId("inputLabelText");
        moistureGoalInputText.setPromptText("12%");


        // Bottom - start button
        Button startButton = new Button("Start");
        startButton.setId("inputButtonStart");

        startButton.setOnAction(e -> {
            TREE_SPECIES = treeSpeciesInputText.getText();
            WIDTH_DIMENTION = treeSpeciesInputText.getText();
            HEIGHT_DIMENTION = heightInputText.getText();
            SAWSET = sawsetInputText.getText();
            MOISTURE_GOAL = moistureGoalInputText.getText();

            // Call på getKwh()
            try {
                //Main.createLineChart();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
            window.close();
        });

        VBox layout = new VBox(10);
        layout.getChildren().addAll(inputLabel, treeSpeciesInputLabel, treeSpeciesInputText, widthInputLabel, widthInputText, heightInputLabel, heightInputText,
                sawsetInputLabel, sawsetInputText, moistureGoalInputLabel, moistureGoalInputText, startButton);
        layout.setAlignment(Pos.CENTER);

        Scene scene = new Scene(layout, 600, 600);
        scene.getStylesheets().add(InputPopUpWindow.class.getResource("/com.application/CSS/styleSheet.css").toExternalForm());
        window.setScene(scene);
        window.showAndWait();
    }

}
