package com.application.GUI;

import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

public class LineChartFunctionality {

    private LineChart<String, Number> lineChart;
    private XYChart.Series<String, Number> series;
    private final CategoryAxis xAxis;
    private final NumberAxis yAxis;


    public LineChartFunctionality(){
        this.xAxis = new CategoryAxis();
        this.yAxis = new NumberAxis();
        this.series = new XYChart.Series<String, Number>();
        this.lineChart = new LineChart<>(xAxis,yAxis);
        this.lineChart.getData().add(series);
        this.xAxis.setLabel("Date");
        this.yAxis.setLabel("Kwh");
        this.lineChart.setTitle("Drying Processes");
    }

    public LineChart<String, Number> getLineChart() {
        return this.lineChart;
    }

    public void setLineChart(LineChart<String, Number> lineChart) {
        this.lineChart = lineChart;
    }

    public XYChart.Series<String, Number> getSeries() {
        return this.series;
    }

    public void setSeries(XYChart.Series<String, Number> series) {
        this.series = series;
        this.lineChart.getData().add(series);
    }

}
