package com.application.DB;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

/**
 * This class contains constants to be used related to database activities
 */
public final class Constants {

    // Format for today's date
    static DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    private Constants() {
        // Empty constructor
    }

    // Today's date
    public static final String TODAYS_DATE = format.format(LocalDateTime.now());

    // User inputs
    public static final String TREE_SPECIES = "";
    public static final String WIDTH_DIMENTION = "";
    public static final String HEIGHT_DIMENTION = "";
    public static final String SAWSET = "";
    public static final int MOISTURE_GOAL = 0;

    // Database ID/name
    public static final String PROJECT_ID = "sf-drying-optimization";


    // Location Valasen(124)
    // Project settings
    public static final int LOCATION_ID = 124;
    public static final String TABLE_NAME_VALMATICS = "int_dk_valmaticsdryingbatches_v2";
    public static final String TABLE_NAME_KWH = "int_sd_winccsensordata";

    // Parameters settings
    // Valmatics
    public static final String OTHER_PARAMETERS_NAME = "Name";
    public static final String START_DRYING_NAME = "DryingStarted";
    public static final String STOP_DRYING_NAME = "CalculatedStop";
    public static final String KILIN_NAME = "KilnName";
    public static int KILIN_ID = 5;

    // Winccsensordata
    public static final String KWH_NAME = "VariantValue";
    public static final String TIMESTAMP_NAME = "Timestamp";
    public static final String VALUE_ID_NAME = "ValueID";
    public static final int VALUE_ID = 51;
    public static final int LIMIT = 1000;




/*
    // Location Arjang(174)
    // Project settings
    public static final int LOCATION_ID = 174;
    public static final String TABLE_NAME_VALMATICS = "int_dk_valmaticsdryingbatches";
    public static final String TABLE_NAME_KWH = "int_sd_swappconsensordata";

    // Parameters settings
    // Valmatics
    public static final String OTHER_PARAMETERS_NAME = "Name";
    public static final String START_DRYING_NAME = "DryingStarted";
    public static final String STOP_DRYING_NAME = "DryingCompleted";
    public static final String KILIN_NAME = "KilinId";
    public static int KILIN_ID = 17;

    // Swappconsensordata
    public static final String KWH_NAME = "RealValue";
    public static final String TIMESTAMP_NAME = "Timestamp";
    public static final String VALUE_ID_NAME = "ValueID";
    public static final int VALUE_ID = 19;
    public static final int LIMIT = 1000;

 */






}
