package com.application.GUI;

import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.*;
import javafx.scene.chart.LineChart;
import javafx.scene.control.*;
import javafx.scene.layout.*;
import javafx.stage.*;

import java.util.concurrent.*;

import static com.application.DB.Constants.*;
import static com.application.Main.*;
import static com.application.DB.DB.setInputParameters;
import static com.application.GUI.LineChartFunctionality.loadSingleSeries;


/**
 * This class handles the popup input window
 *
 * @author Eilert Tunheim, Karin Pettersen, Mads Arnesen
 * @version 1.0
 */
public class InputPopUpWindow {

    public static CompletableFuture<LineChart<String, Number>> getData(){
        CompletableFuture<LineChart<String, Number>> completableFuture = new CompletableFuture<>();

        Executors.newCachedThreadPool().submit(() -> {
            Thread.sleep(500);
            completableFuture.complete(loadSingleSeries(setInputParameters()));
            return null;
        });

        return completableFuture;
    }

    public static void display() {
        Stage window = new Stage();

        window.initModality(Modality.APPLICATION_MODAL);
        window.setTitle("Input Parameters");

        // Top
        Label inputLabel= new Label("Input");
        inputLabel.setId("inputTop");

        // Center - Input fields
        // Tree species
        Label treeSpeciesInputLabel = new Label("Tree Species");
        treeSpeciesInputLabel.setId("inputLabel");
        ObservableList<String> treeSpecies = FXCollections.observableArrayList(
                 "Furu",
                        "Gran"
        );
        ComboBox<String> treeSpeciesList = new ComboBox<>(treeSpecies);
        treeSpeciesList.setPromptText("Select Tree Species");
        treeSpeciesList.setId("inputDropDownBox");
        treeSpeciesList.setEditable(true);

        // Dimensions
        Label dimensionsInputLabel = new Label("Dimensions");
        dimensionsInputLabel.setId("inputLabel");
        ObservableList<String> dimensions = FXCollections.observableArrayList(
         "47x150",
                "47x175",
                "47x200",
                "47x225",
                "47x250",
                "50x150",
                "50x175",
                "50x200",
                "50x225",
                "50x250"
                );
        ComboBox<String> dimensionsList = new ComboBox<>(dimensions);
        dimensionsList.setPromptText("Select Dimensions");
        dimensionsList.setId("inputDropDownBox");
        dimensionsList.setEditable(true);



        // Sawset
        Label sawsetInputLabel = new Label("Sawset");
        sawsetInputLabel.setId("inputLabel");
        ObservableList<String> sawset = FXCollections.observableArrayList(
                     "1ex",
                            "2ex",
                            "3ex",
                            "4ex"
        );
        ComboBox<String> sawsetList = new ComboBox<>(sawset);
        sawsetList.setPromptText("Select Dimensions");
        sawsetList.setId("inputDropDownBox");
        sawsetList.setEditable(true);

        // Moisture
        Label moistureGoalInputLabel = new Label("Moisture Goal");
        moistureGoalInputLabel.setId("inputLabel");
        ObservableList<String> moistureGoal = FXCollections.observableArrayList(
                 "10%",
                        "12%",
                        "14%",
                        "16%",
                        "18%",
                        "20%"
        );
        ComboBox<String> moistureList = new ComboBox<>(moistureGoal);
        moistureList.setPromptText("Select Dimensions");
        moistureList.setId("inputDropDownBox");
        moistureList.setEditable(true);


        // Bottom - start button
        Button startButton = new Button("Start");
        startButton.setId("inputButtonStart");

        startButton.setOnAction(e -> {
                    // Retrieves the user inputs
                    TREE_SPECIES = treeSpeciesList.getValue();
                    DIMENSIONS = dimensionsList.getValue();
                    SAWSET = sawsetList.getValue();
                    if(moistureList.getValue() != null && moistureList.getValue().contains("%"))
                    {
                        MOISTURE_GOAL = moistureList.getValue().replace("%","");
                    } else {
                        MOISTURE_GOAL = moistureList.getValue();
                    }


                    // If the input is null, sets the value to be empty
                    if (treeSpeciesList.getValue() == null) {
                        TREE_SPECIES = "";
                    }
                    if (dimensionsList.getValue() == null) {
                        DIMENSIONS = "";
                    }
                    if (sawsetList.getValue() == null) {
                        SAWSET = "";
                    }
                    if (moistureList.getValue() == null) {
                        MOISTURE_GOAL = "";
                    }

                    setTreeSpeciesText(TREE_SPECIES);
                    setDimensionsText(DIMENSIONS);
                    setSawsetText(SAWSET);
                    setMoistureGoalText(MOISTURE_GOAL);

                    window.close();




/*
                    FutureTask[] randomNumberTasks = new FutureTask[1];
                    Callable callable = new CallableExample();
                    randomNumberTasks[0] = new FutureTask(callable);
                    Thread t = new Thread(randomNumberTasks[0]);
                    t.start();

                    try {
                        System.out.println(randomNumberTasks[0].get());
                    } catch (InterruptedException | ExecutionException ex) {
                        ex.printStackTrace();
                    }

                });

 */



                    try {
                        //getData();
                        loadSingleSeries(setInputParameters());
                        //loadMultipleSeries(setInputParameters());
                        //loadSingleSeries();
                        //loadMultipleSeries();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                );





/*
            try{
                Thread thread = new Thread(new Runnable() {

                    @Override
                    public void run() {
                        try {
                            // Henter her data fra databasen
                            loadSingleSeries(setInputParameters(false,false,false,false));
                            //loadSingleSeries();
                            //loadMultipleSeries();
                        } catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                });
                thread.start();
            } catch (Exception ex) {
                ex.printStackTrace();
            }
                }
                );

 */

/*
                    // Fungerende ny thread!!@@@@@
                    try{
                        Thread thread = new Thread(new Runnable() {

                            @Override
                            public void run() {
                                try {
                                    // Henter her data fra databasen
                                    loadSingleSeries(setInputParameters());
                                    //loadSingleSeries();
                                    //loadMultipleSeries();
                                } catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                        });
                        thread.start();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }

                );

 */

/*
            class KwhThread implements Runnable  {

                Map<Integer, Map<String, Number>> dataVariable;
                private volatile boolean finished;

                @Override
                public void run() {
                    try{
                        dataVariable = setInputParameters();
                    } catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finished = true;

                    synchronized (this){
                        this.notify();
                    }
                }

                public Map<Integer, Map<String, Number>> getDataVariable() throws InterruptedException {

                    synchronized (this){
                        if(!finished)
                        this.wait();
                    }
                    return dataVariable;
                }
            }

            KwhThread kwhThread = new KwhThread();

            Thread thread = new Thread(kwhThread);
            thread.setName("GetKwhThread");
            thread.start();

            try {
                loadSingleSeries(kwhThread.getDataVariable());
            } catch (Exception ex) {
                ex.printStackTrace();
            }


 */

/*


 */


        VBox layout = new VBox(10);
        layout.getChildren().addAll(inputLabel, treeSpeciesInputLabel, treeSpeciesList, dimensionsInputLabel, dimensionsList,
                sawsetInputLabel, sawsetList, moistureGoalInputLabel, moistureList, startButton);
        layout.setAlignment(Pos.CENTER);

        Scene scene = new Scene(layout, 600, 500);
        scene.getStylesheets().add(InputPopUpWindow.class.getResource("/com.application/CSS/styleSheet.css").toExternalForm());
        window.setScene(scene);
        window.showAndWait();
    }

}
