package com.application.GUI;

import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.shape.Line;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class LineChartFunctionality {

    private static LineChart<String, Number> lineChart;
    private static CategoryAxis xAxis;
    private static NumberAxis yAxis;


    public LineChartFunctionality() {
        xAxis = new CategoryAxis();
        yAxis = new NumberAxis();
        lineChart = new LineChart<>(xAxis, yAxis);
        xAxis.setLabel("Date");
        xAxis.setAnimated(false);
        yAxis.setLabel("Kwh");
        yAxis.setAnimated(false);
        lineChart.setTitle("Drying Processes");
    }

    public static void setLineChart(LineChart<String, Number> lineChart) {
        LineChartFunctionality.lineChart = lineChart;
    }

    public static LineChart<String, Number> getLineChart() {
        return lineChart;
    }

    public static void updateLineChart(XYChart.Series<String, Number> series) {
        lineChart.getData().add(series);
    }

    public static void clearLineChart() {
        lineChart.getData().clear();
    }

    private static long findDifference(String start_date, String end_date) {
        // Defining a simple date format
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        try{
            // try to convert the string to Date datatype
            Date dateStart = dateFormat.parse(start_date);
            Date dateEnd = dateFormat.parse(end_date);

            // Finds the difference in millis
            long differenceMillis = dateEnd.getTime() - dateStart.getTime();

           // Finds the difference in minutes
            return (differenceMillis / (1000 * 60 )) % 60;

        } catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return 0;
    }


    public static LineChart<String, Number> loadSingleSeries(Map<Integer, Map<String, Number>> userInput) throws Exception {
        clearLineChart();

        //Map<Integer, Map<String, Number>> kWh = userInput;
        //Map<Integer, Map<String, Number>> kWh = DB.setInputParameters();
        //System.out.println(kWh.size());

        for (Map.Entry<Integer, Map<String, Number>> entryKwh : userInput.entrySet()) {
            Map data = entryKwh.getValue();
            //System.out.println(data.size());
            XYChart.Series<String, Number> newSeries = new XYChart.Series<String, Number>();
            long minutes = 0;
            long hours;
            String previouseDate = "";
            for (Object entryData : data.entrySet()) {
                //System.out.println("data: \t"+entryData);
                String entryString = entryData.toString();
                String[] arr = entryString.split("=");
                String currentDate = arr[0];
                int kwhValue = Integer.parseInt(arr[1]);


                //System.out.printf("previouse date: \t%s\n",previouseDate);
                //System.out.printf("Current date: \t\t%s\n",currentDate);
                //System.out.printf("is prev empty?: \t%s\n",previouseDate.isEmpty());


                minutes += findDifference(previouseDate, currentDate);

                hours = (minutes/60);
                System.out.println(hours);
                previouseDate = currentDate;

                //System.out.printf("Date: \t%s\t\t\tkWh: \t%s\n",date,kwhValue);
                //System.out.printf("Hours: \t\t%s\n",hours);


                // Connect the data to a series
                newSeries.getData().add(new XYChart.Data<String, Number>(String.valueOf(hours), kwhValue));
            }
            updateLineChart(newSeries);
        }
        return getLineChart();
    }

    public static LineChart<String, Number> loadMultipleSeries(Map<Integer, Map<String, Number>> userInput) throws Exception {

        //Map<Integer, Map<String, Number>> kWh = DB.setInputParameters();
        //System.out.println(kWh.size());

        for (Map.Entry<Integer, Map<String, Number>> entryKwh : userInput.entrySet()) {
            Map data = entryKwh.getValue();
            //System.out.println(data.size());

            XYChart.Series<String, Number> newSeries = new XYChart.Series<String, Number>();
            for (Object entryData : data.entrySet()) {
                //System.out.println("data: \t"+entryData);
                String entryString = entryData.toString();
                String[] arr = entryString.split("=");
                String date = arr[0];
                int kwhValue = Integer.parseInt(arr[1]);

                //System.out.printf("Date: \t%s\t\t\tkWh: \t%s\n",date,kwhValue);


                // Connect the data to a series
                newSeries.getData().add(new XYChart.Data<String, Number>(date, kwhValue));

            }
            updateLineChart(newSeries);
        }
        return getLineChart();
    }
}
