package com.application.DB;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;

/**
 * This class contains constants to be used related to database activities
 */
public final class Constants {

    private Constants() {
        // Empty constructor
    }

    // Today's date
    public static final String TODAYS_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());

    // User inputs
    public static String TREE_SPECIES = "";
    public static  String DIMENSIONS = "";
    public static  String SAWSET = "";
    public static  String MOISTURE_GOAL = "";

    // Number of wanted drying periods
    public static int NUMBER_OF_PERIODS = 1;

    // Database ID/name
    public static final String PROJECT_ID = "sf-drying-optimization";


    // Location Valasen(124)
    // Project settings
    public static final int VALASEN_LOCATION_ID = 124;
    public static final String VALASEN_TABLE_NAME_VALMATICS = "int_dk_valmaticsdryingbatches_v2";
    public static final String VALASEN_TABLE_NAME_KWH = "int_sd_winccsensordata";

    // Parameters settings
    // Valmatics
    public static final String VALASEN_NAME_PARAMATERS = "Name";
    public static final String VALASEN_START_DRYING_NAME = "DryingStarted";
    public static final String VALASEN_STOP_DRYING_NAME = "CalculatedStop";
    public static final String VALASEN_KILIN_NAME = "KilnName";
    public static int VALASEN_KILIN_ID = 5;                 // Kammer 5
    //public static int VALASEN_KILIN_ID = 6;                 // Kammer 6
    public static final int VALASEN_LIMIT = 1000;

    // Winccsensordata
    public static final String VALASEN_KWH_NAME = "VariantValue";
    public static final String VALASEN_TIMESTAMP_NAME = "Timestamp";
    public static final String VALASEN_VALUE_ID_NAME = "ValueID";
    public static final int VALASEN_VALUE_ID = 51;          // Kammer 5
    //public static final int VALASEN_VALUE_ID = 56;          // Kammer 6






    // Location Arjang(174)
    // Project settings
    public static final int ARJANG_LOCATION_ID = 174;
    public static final String ARJANG_TABLE_NAME_VALMATICS = "int_dk_valmaticsdryingbatches";
    public static final String ARJANG_TABLE_NAME_KWH = "int_sd_swappconsensordata";

    // Parameters settings
    // Valmatics
    public static final String ARJANG_NAME_PARAMATERS = "Name";
    public static final String ARJANG_START_DRYING_NAME = "DryingStarted";
    public static final String ARJANG_STOP_DRYING_NAME = "DryingCompleted";
    public static final String ARJANG_KILIN_NAME = "KilinId";
    public static int ARJANG_KILIN_ID = 18;
    //public static int ARJANG_KILIN_ID = 18554;
    public static final int ARJANG_LIMIT = 1000;

    // Swappconsensordata
    public static final String ARJANG_KWH_NAME = "RealValue";
    public static final String ARJANG_TIMESTAMP_NAME = "Timestamp";
    public static final String ARJANG_VALUE_ID_NAME = "ValueID";
    public static final int ARJANG_VALUE_ID = 19;




    public static HashMap<Integer, HashMap<String, HashMap<String, String>>> getSawmills(){
        HashMap<Integer, HashMap<String, HashMap<String, String>>> sawmillInfo = new HashMap<>();
        sawmillInfo.put(VALASEN_LOCATION_ID, getValasenTables());
        sawmillInfo.put(ARJANG_LOCATION_ID, getArjangTables());
        return sawmillInfo;
    }

    // Valasen
    private static HashMap<String, HashMap<String, String>> getValasenTables(){
        HashMap<String, HashMap<String, String>> valasenTables = new HashMap<>();
        valasenTables.put(getValasenTableNames().get("Valmetics"), getValasenValmeticsParameters());
        valasenTables.put(getValasenTableNames().get("Kwh"), getValasenWinccsensordataParameters());
        return valasenTables;
    }

    public static HashMap<String, String> getValasenTableNames(){
        HashMap<String, String> valasenTables = new HashMap<>();
        valasenTables.put("Valmetics", VALASEN_TABLE_NAME_VALMATICS);
        valasenTables.put("Kwh", VALASEN_TABLE_NAME_KWH);
        return valasenTables;
    }

    private static HashMap<String, String> getValasenValmeticsParameters(){
        HashMap<String, String> valasenValmeticsParameters = new HashMap<>();
        valasenValmeticsParameters.put("Name", VALASEN_NAME_PARAMATERS);
        valasenValmeticsParameters.put("DryingStarted", VALASEN_START_DRYING_NAME);
        valasenValmeticsParameters.put("DryingStopped", VALASEN_STOP_DRYING_NAME);
        valasenValmeticsParameters.put("KilnName", VALASEN_KILIN_NAME);
        valasenValmeticsParameters.put("KilinID", String.valueOf(VALASEN_KILIN_ID));
        valasenValmeticsParameters.put("Limit", String.valueOf(VALASEN_LIMIT));
        return valasenValmeticsParameters;
    }

    private static HashMap<String, String> getValasenWinccsensordataParameters(){
        HashMap<String, String> valasenWinccsensordataParameters = new HashMap<>();
        valasenWinccsensordataParameters.put("KwhName", VALASEN_KWH_NAME);
        valasenWinccsensordataParameters.put("Timestamp", VALASEN_TIMESTAMP_NAME);
        valasenWinccsensordataParameters.put("ValueIDName", VALASEN_VALUE_ID_NAME);
        valasenWinccsensordataParameters.put("ValueID", String.valueOf(VALASEN_VALUE_ID));
        return valasenWinccsensordataParameters;
    }

    // Arjang
    private static HashMap<String, HashMap<String, String>> getArjangTables(){
        HashMap<String, HashMap<String, String>> arjangTables = new HashMap<>();
        arjangTables.put(getArjangTableNames().get("Valmetics"), getArjangValmeticsParameters());
        arjangTables.put(getArjangTableNames().get("Kwh"), getArjangWinccsensordataParameters());
        return arjangTables;
    }

    public static HashMap<String, String> getArjangTableNames(){
        HashMap<String, String> valasenTables = new HashMap<>();
        valasenTables.put("Valmetics", ARJANG_TABLE_NAME_VALMATICS);
        valasenTables.put("Kwh", ARJANG_TABLE_NAME_KWH);
        return valasenTables;
    }

    private static HashMap<String, String> getArjangValmeticsParameters(){
        HashMap<String, String> arjangValmeticsParameters = new HashMap<>();
        arjangValmeticsParameters.put("Name", ARJANG_NAME_PARAMATERS);
        arjangValmeticsParameters.put("DryingStarted", ARJANG_START_DRYING_NAME);
        arjangValmeticsParameters.put("DryingStopped", ARJANG_STOP_DRYING_NAME);
        arjangValmeticsParameters.put("KilnName", ARJANG_KILIN_NAME);
        arjangValmeticsParameters.put("KilinID", String.valueOf(ARJANG_KILIN_ID));
        arjangValmeticsParameters.put("Limit", String.valueOf(ARJANG_LIMIT));
        return arjangValmeticsParameters;
    }

    private static HashMap<String, String> getArjangWinccsensordataParameters(){
        HashMap<String, String> arjangWinccsensordataParameters = new HashMap<>();
        arjangWinccsensordataParameters.put("KwhName", ARJANG_KWH_NAME);
        arjangWinccsensordataParameters.put("Timestamp", ARJANG_TIMESTAMP_NAME);
        arjangWinccsensordataParameters.put("ValueIDName", ARJANG_VALUE_ID_NAME);
        arjangWinccsensordataParameters.put("ValueID", String.valueOf(ARJANG_VALUE_ID));
        return arjangWinccsensordataParameters;
    }
}
