package com.application.GUI;

import com.application.DB.DB;
import javafx.scene.chart.CategoryAxis;
import javafx.scene.chart.LineChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;

import java.util.Map;

public class LineChartFunctionality {

    private static LineChart<String, Number> lineChart;
    private static CategoryAxis xAxis;
    private static NumberAxis yAxis;


    public LineChartFunctionality() {
        xAxis = new CategoryAxis();
        yAxis = new NumberAxis();
        lineChart = new LineChart<>(xAxis, yAxis);
        xAxis.setLabel("Date");
        xAxis.setAnimated(false);
        yAxis.setLabel("Kwh");
        yAxis.setAnimated(false);
        lineChart.setTitle("Drying Processes");
    }

    public static void setLineChart(LineChart<String, Number> lineChart) {
        LineChartFunctionality.lineChart = lineChart;
    }

    public static LineChart<String, Number> getLineChart() {
        return lineChart;
    }

    public static void updateLineChart(XYChart.Series<String, Number> series) {
        lineChart.getData().add(series);
    }

    public static void clearLineChart() {
        lineChart.getData().clear();
    }


    public static LineChart<String, Number> loadSingleSeries(Map<Integer, Map<String, Number>> userInput) throws Exception {
        clearLineChart();

        //Map<Integer, Map<String, Number>> kWh = userInput;
        //Map<Integer, Map<String, Number>> kWh = DB.setInputParameters();
        //System.out.println(kWh.size());

        for (Map.Entry<Integer, Map<String, Number>> entryKwh : userInput.entrySet()) {
            Map data = entryKwh.getValue();
            //System.out.println(data.size());
            XYChart.Series<String, Number> newSeries = new XYChart.Series<String, Number>();
            int index = 0;
            for (Object entryData : data.entrySet()) {
                //System.out.println("data: \t"+entryData);
                String entryString = entryData.toString();
                String[] arr = entryString.split("=");
                String date = arr[0];
                int kwhValue = Integer.parseInt(arr[1]);

                //System.out.printf("Date: \t%s\t\t\tkWh: \t%s\n",date,kwhValue);


                // Connect the data to a series
                newSeries.getData().add(new XYChart.Data<String, Number>(String.valueOf(index), kwhValue));
                index += 1;
            }
            updateLineChart(newSeries);
        }
        return getLineChart();
    }

    public static LineChart<String, Number> loadMultipleSeries(Map<Integer, Map<String, Number>> userInput) throws Exception {

        //Map<Integer, Map<String, Number>> kWh = DB.setInputParameters();
        //System.out.println(kWh.size());

        for (Map.Entry<Integer, Map<String, Number>> entryKwh : userInput.entrySet()) {
            Map data = entryKwh.getValue();
            //System.out.println(data.size());

            XYChart.Series<String, Number> newSeries = new XYChart.Series<String, Number>();
            for (Object entryData : data.entrySet()) {
                //System.out.println("data: \t"+entryData);
                String entryString = entryData.toString();
                String[] arr = entryString.split("=");
                String date = arr[0];
                int kwhValue = Integer.parseInt(arr[1]);

                //System.out.printf("Date: \t%s\t\t\tkWh: \t%s\n",date,kwhValue);


                // Connect the data to a series
                newSeries.getData().add(new XYChart.Data<String, Number>(date, kwhValue));

            }
            updateLineChart(newSeries);
        }
        return getLineChart();
    }
}
