package com.application.GUI;

import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class OutputPopUpWindow {

    public static void displayOutputWindow(){

        Stage window = new Stage();
        window.initModality(Modality.APPLICATION_MODAL);
        window.setTitle("Moisture Check");

        // Top
        Label moistureCheckLabelHuge = new Label("Moisture Check");
        moistureCheckLabelHuge.setId("inputTop");
        moistureCheckLabelHuge.setAlignment(Pos.TOP_CENTER);

        // Center - Output field
        Label moistureCheckLabelSmall = new Label("Moisture Check:");
        moistureCheckLabelSmall.setId("inputLabel");
        moistureCheckLabelSmall.setAlignment(Pos.CENTER);
        TextField moistureCheckTextField = new TextField();
        moistureCheckTextField.setId("inputLabel");
        moistureCheckTextField.setAlignment(Pos.CENTER);

        // Bottom - Buttons
        Button countinueButton = new Button("Continue");
        countinueButton.setId("inputButtonStart");
        countinueButton.setAlignment(Pos.BOTTOM_CENTER);
        Button finishButton = new Button("Finish");
        finishButton.setId("inputButtonStart");
        finishButton.setAlignment(Pos.BOTTOM_CENTER);


        VBox layout = new VBox(10);
        layout.setAlignment(Pos.CENTER);
        layout.getChildren().addAll(moistureCheckLabelHuge,moistureCheckLabelSmall,moistureCheckTextField,countinueButton,finishButton);

        Scene scene = new Scene(layout, 600, 500);
        scene.getStylesheets().add(InputPopUpWindow.class.getResource("/com.application/CSS/styleSheet.css").toExternalForm());
        window.setScene(scene);
        window.showAndWait();
    }

}
