package com.application;

import com.application.DB.Constants;
import com.application.GUI.InputPopUpWindow;
import com.application.GUI.OutputPopUpWindow;
import com.application.GUI.RingProgressIndicator;
import com.application.GUI.LineChartFunctionality;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.chart.LineChart;
import javafx.scene.control.*;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.*;
import javafx.scene.Scene;
import javafx.stage.Stage;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Logger;

import static com.application.DB.Constants.*;
import static java.util.logging.Level.SEVERE;

/**
 * This class launches the application
 *
 * @author Eilert Tunheim, Karin Pettersen, Mads Arnesen
 * @version 1.0.0
 */
public class Main extends Application {

    private BorderPane topBar;
    private HBox logoBar;
    private VBox sideBar;
    private MenuBar menuBar;
    private LineChartFunctionality lineChartFunctionality;

    private static TextField treeSpeciesText;
    private static TextField dimensionsText;
    private static TextField sawsetText;
    private static TextField moistureGoalText;

    /**
     * Starts the application
     *
     * @param args
     * @throws IOException
     */
    public static void main(String[] args) throws IOException {
        launch(args);
    }

    /**
     * Initializes the application with all the different panes.
     *
     * @throws Exception Exception in super.
     */
    @Override
    public void init() throws Exception {
        super.init();

        // Initializing variables
        this.topBar = new BorderPane();
        this.logoBar = new HBox();
        this.sideBar = new VBox();
        this.menuBar = new MenuBar();
        this.lineChartFunctionality = new LineChartFunctionality();
    }

    /**
     * Sets the primaryStage and sets the scene for the window.
     *
     * @param primaryStage
     * @throws Exception
     */
    @Override
    public void start(Stage primaryStage) throws Exception {

        // Create panes for root
        BorderPane root = new BorderPane();
        this.menuBar = createMenuBar();
        this.sideBar = createSideBar();
        this.logoBar = createLogoBar();

        LineChart<String, Number> lineChart = this.lineChartFunctionality.getLineChart();

        //Set id's to connect to css stylesheet
        root.setId("root");
        this.logoBar.setId("logoBar");
        this.menuBar.setId("menuBar");
        this.sideBar.setId("sideBar");
        lineChart.setId("lineChart");


        // Sett the menubar in a vbox inorder to stretch over the whole screen
        VBox vBox = new VBox(this.menuBar);

        // Sets alignment for the topBar
        this.topBar.setTop(vBox);
        this.topBar.setCenter(logoBar);

        // Sets alignment for the panes to the parent root
        root.setTop(this.topBar);
        root.setLeft(this.sideBar);
        root.setCenter(lineChart);

        VBox.setVgrow(this.logoBar, Priority.ALWAYS);

        // Sets the scene and defines boundaries
        Scene scene = new Scene(root, 1200, 600);
        scene.getStylesheets().add(getClass().getResource("/com.application/CSS/styleSheet.css").toExternalForm());

        primaryStage.setTitle("Moelven Drying Application");
        primaryStage.setMaximized(true);
        primaryStage.setMinHeight(600);
        primaryStage.setMinWidth(1200);
        primaryStage.setScene(scene);
        primaryStage.show();

        // Displays the input parameters popup window
        InputPopUpWindow.display();

        System.out.println(Constants.getSawmills());
    }

    /**
     * Creates the menubar with buttons.
     * Defines each action when button is clicked.
     *
     * @return MenuBar as a HBox
     */
    private MenuBar createMenuBar() {

        // Creating a menubar
        MenuBar menuBar = new MenuBar();

        // Defining the individual menus
        Menu menuFile = new Menu("File");
        Menu menuEdit = new Menu("Edit");
        Menu menuHelp = new Menu("Help");


        // Adding the menus to the menubar
        menuBar.getMenus().add(menuFile);
        menuBar.getMenus().add(menuEdit);
        menuBar.getMenus().add(menuHelp);

        // Returns the menubar
        return menuBar;
    }



    private VBox createSideBar(){

        // Creating a vbox
        VBox sideBarVBox = new VBox();

        Label treeSpeciesLabel = new Label("Tree Species");
        treeSpeciesLabel.setId("sideBarLabelText");
        treeSpeciesText = new TextField();
        treeSpeciesText.setId("sideBarLabelText");
        treeSpeciesText.setPromptText("Gran");
        treeSpeciesText.setText(TREE_SPECIES);
        treeSpeciesText.setEditable(false);

        Label dimensionsLabel = new Label("Width x Height");
        dimensionsLabel.setId("sideBarLabelText");
        dimensionsText = new TextField();
        dimensionsText.setId("sideBarLabelText");
        dimensionsText.setPromptText("47 x 150");
        dimensionsText.setText(DIMENSIONS);
        dimensionsText.setEditable(false);

        Label sawsetLabel = new Label("Sawset");
        sawsetLabel.setId("sideBarLabelText");
        sawsetText = new TextField();
        sawsetText.setId("sideBarLabelText");
        sawsetText.setPromptText("4x");
        sawsetText.setText(SAWSET);
        sawsetText.setEditable(false);

        Label moistureGoalLabel = new Label("Moisture Goal");
        moistureGoalLabel.setId("sideBarLabelText");
        moistureGoalText = new TextField();
        moistureGoalText.setId("sideBarLabelText");
        moistureGoalText.setPromptText("16%");
        moistureGoalText.setText(MOISTURE_GOAL);
        moistureGoalText.setEditable(false);

        Button inputParametersButton = new Button("Input Parameters");
        inputParametersButton.setId("sideBarButtonInputParameters");
        inputParametersButton.setOnAction(e -> InputPopUpWindow.display());

        Button finishButton = new Button("Finish");
        finishButton.setId("sideBarButtonFinish");
        finishButton.setOnAction(e -> OutputPopUpWindow.displayOutputWindow());



        // Creating the circular progressbar
        RingProgressIndicator ringProgressIndicator = new RingProgressIndicator();
        ringProgressIndicator.setRingWidth(100);
        ringProgressIndicator.makeIndeterminate();

        class WorkerThread extends Thread{
            RingProgressIndicator rpi;
            int progress = 0;

            public WorkerThread(RingProgressIndicator rpi){
                this.rpi = rpi;
            }

            @Override
            public void run(){
                try {
                    Thread.sleep(100000);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                while (true){
                    try {
                        Thread.sleep(100);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                        Logger.getLogger(getClass().getName()).log(SEVERE,null,e);
                    }
                    Platform.runLater(() -> {rpi.setProgress(progress);});

                    progress += 1;
                    if(progress>100){
                        break;
                    }
                }
            }
        }

        new WorkerThread(ringProgressIndicator).start();



        sideBarVBox.getChildren().addAll(ringProgressIndicator, treeSpeciesLabel, treeSpeciesText, dimensionsLabel, dimensionsText,
                sawsetLabel, sawsetText, moistureGoalLabel, moistureGoalText, inputParametersButton, finishButton);

        VBox.setVgrow(sideBarVBox, Priority.ALWAYS);

        return sideBarVBox;
    }


    /**
     * This function imports the logos and defines the alignments
     *
     * @return a logoBar containing the logos in proper alignments
     * @throws FileNotFoundException
     */
    private HBox createLogoBar() throws FileNotFoundException {
        // Defining the image paths
        Image moelvenLogoM = new Image(new FileInputStream("src/main/resources/com.application/GUI/moelven_logo_m.png"));
        Image moelvenLogoTitle = new Image(new FileInputStream("src/main/resources/com.application/GUI/moelven_logo_title.png"));

        // Creating imageview objects
        ImageView imageViewM = new ImageView(moelvenLogoM);
        ImageView imageViewTitle = new ImageView(moelvenLogoTitle);

        // Defining resolution and aspect ratio
        imageViewM.setFitHeight(100);
        imageViewM.setPreserveRatio(true);
        imageViewTitle.setFitHeight(100);
        imageViewTitle.setPreserveRatio(true);

        // Defining alignments
        Region region1 = new Region();
        HBox.setHgrow(region1, Priority.ALWAYS);

        Region region2 = new Region();
        HBox.setHgrow(region2, Priority.ALWAYS);

        return new HBox(imageViewM, region1, imageViewTitle, region2);
    }




    public static void setTreeSpeciesText(String treeSpeciesText) {
        Main.treeSpeciesText.setText(treeSpeciesText);
    }

    public static void setDimensionsText(String dimensionsText)  {
        Main.dimensionsText.setText(dimensionsText);
    }

    public static void setSawsetText(String sawsetText) {
        Main.sawsetText.setText(sawsetText);
    }

    public static void setMoistureGoalText(String moistureGoalText) {
        Main.moistureGoalText.setText(moistureGoalText);
    }
}


