package main

import (
    "fmt"
    "log"
    "net/http"
    "os"
    "assignment1"
)



func main() {
    assignment1.Start()
    port := os.Getenv("PORT")
    if port == "" {
        port = "8080"
    }

    http.HandleFunc("/conservation/v1/", assignment1.HomePage)
    http.HandleFunc("/conservation/v1/country/", assignment1.Countries)
    http.HandleFunc("/conservation/v1/species/", assignment1.Species)
    http.HandleFunc("/conservation/v1/diag/", assignment1.Diag)
    fmt.Println("Listening on port " + port)
    log.Fatal(http.ListenAndServe(":"+port, nil))
}
