package assignment1

import (
    "fmt"
    "net/http"
    "strings"
    "encoding/json"
    "io/ioutil"
    "time"

)
//URLS
var url1 string = "https://restcountries.eu/rest/v2"
var url2 string = "http://api.gbif.org/v1"
//Variables
var startTime time.Time

//Function to start timer
func Start(){
    startTime = time.Now()
}

func HomePage(w http.ResponseWriter, r *http.Request) {
    fmt.Fprintf(w, "Welcome to the HomePage! Type in an endpoint!")
    fmt.Println("Endpoint Hit: homePage")
}


func Species(w http.ResponseWriter, r *http.Request){
    //Splitting the input path to get speciesKey
    parts := strings.Split(r.URL.Path, "/")
    if len(parts) != 5 {
        status := http.StatusBadRequest
        http.Error(w, "Expecting format .../{:speciesKey}", status)

        return
    }

    spekey := parts[4]
		//Variable for Specie struct
    var specie Specie

	  //Get response from api
    res1, err := http.Get(url2+"/species/"+spekey+"/name")
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
	  }
    //Collecting the response data
    resData1, err := ioutil.ReadAll(res1.Body)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }

		//Adding the correct info to specie struct
    json.Unmarshal([]byte(resData1), &specie)

		//Get response from api
    res2, err := http.Get(url2+"/species/"+spekey)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
  	//Collecting the response data
    resData2, err := ioutil.ReadAll(res2.Body)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
		//Adding the correct info to specie struct
    json.Unmarshal([]byte(resData2), &specie)

		//Set header
    http.Header.Add(w.Header(), "Content-Type", "application/json")

		//Send json response
    json.NewEncoder(w).Encode(specie)

}

func Countries(w http.ResponseWriter, r *http.Request) {
    //Splitting the input path to get alpha2code and limit request
    parts := strings.Split(r.URL.Path, "/")
    if len(parts) != 5 {
        status := http.StatusBadRequest
        http.Error(w, "Expecting format .../{:country_identifier}{?limit={:limit}}", status)

        return
				}
    //Getting the query limit={int} from url
    limit := r.URL.RawQuery
    //Two struct variables, result is for getting BracketYear
    var country Country
    var result Result
		//Get response from api
    res1, err := http.Get(url1+"/alpha/"+parts[4])
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
		//Collecting the response data
    resData1, err := ioutil.ReadAll(res1.Body)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
		//Adding the correct info to specie struct
    json.Unmarshal([]byte(resData1), &country)
    //Get response from api
    res2, err := http.Get(url2+"/occurrence/search?country="+parts[4]+"&"+limit)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
	  //Collecting the response data
    resData2, err := ioutil.ReadAll(res2.Body)
    if err != nil {
        http.Error(w, http.StatusText(404), 404)
    }
		//Adding the correct info to specie struct
		//Overwriting data from other response, only want to keep Bracketyear
    json.Unmarshal([]byte(resData2), &result)
    //Slices for appending
    var spec []string
    var speckey []int
    //Loops all results and writes in Species and Specieskey to Slices
    for i := 0; i < len(result.Result); i++ {
        if !stringInSlice(result.Result[i].Species, spec) &&
           !intInSlice(result.Result[i].Specieskey, speckey) {

            spec = append(spec, result.Result[i].Species)
            speckey = append(speckey, result.Result[i].Specieskey)
        }
    }
		//Updates the string and int in country struct from slices
    country.Species = spec
    country.Specieskey = speckey
		//Set header
    http.Header.Add(w.Header(), "Content-Type", "application/json")
		//Send json response
    json.NewEncoder(w).Encode(country)

}
//Fuction for checking duplicate in string
func stringInSlice(str string, list []string) bool {
    for _, v := range list {
        if v == str {
            return true
        }
    }
    return false
}
//Fuction for checking duplicate in int array
func intInSlice(str int, list []int) bool {
    for _, v := range list {
        if v == str {
            return true
        }
    }
    return false
}

func Diag(w http.ResponseWriter, r *http.Request){
    //Struct variable for Diagnostic
    var diag Diagnostic
		//Gets StatusCode from api and adds to struct
    res1, _ := http.Get(url1)
    diag.Restcountries = res1.StatusCode
		//Gets StatusCode from api and adds to struct
    res2, _ := http.Get(url2)
    diag.Gbif = res2.StatusCode
		//Writes version to diag
    diag.Version = "v1"
		//Find the uptime for application
    dura := time.Since(startTime)
    diag.Uptime = dura.String()
    //Set header
    http.Header.Add(w.Header(), "Content-Type", "application/json")
		//Send json response
    json.NewEncoder(w).Encode(diag)
}
