-- Testbench of Tx
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

-- Entity of testbench (empty)
entity Tx_tb is
end Tx_tb;

architecture SimulationModel of Tx_tb is

    -- Constant declaration
    constant CLK_PERIOD : time := 20 ns;  -- 50 MHz klokke
	
    -- Component declarasion
    component Tx
        Port (
            clk         : in  std_logic;
            rst_n       : in  std_logic;
	    Rd_sig      : in std_logic;
	    Wr_sig      : in std_logic;
            adresse     : in std_logic_vector(2 downto 0);
            Data_bus    : inout std_logic_vector(7 downto 0);
            TxD         : out std_logic
        );
    end component;

    -- Signal declaration
    signal clk      : std_logic := '0';
    signal rst_n    : std_logic := '1';
    signal adresse  : std_logic_vector(2 downto 0);
    signal Data_bus : std_logic_vector(7 downto 0);
    signal TxD      : std_logic;
    signal Rd_sig   : std_logic;
    signal Wr_sig   : std_logic;

begin

    -- Component instantiations UART TX-modul (DUT)
    DUT: component Tx
        Port Map (
            clk         => clk,
            rst_n       => rst_n,
            adresse     => adresse,
            Data_bus    => Data_bus,
            TxD         => TxD,
	    Rd_sig      => Rd_sig,
	    Wr_sig	=> Wr_sig
        );

    -- Generation of clock
    p_clk: process is
    begin
        clk <= '0';
        wait for CLK_PERIOD / 2;
        clk <= '1';
        wait for CLK_PERIOD / 2;
    end process;

    --Generation of resetN
    p_rst_n: process is
    begin
      rst_n <= '0';
      wait for 2.2*CLK_PERIOD;
      rst_n <= '1';
      wait;
    end process;

    -- Test procedure
    p_test_procedure: process
        
        -- Initialisation of testbench
        procedure tb_init is
	begin
	 adresse <= (others => 'Z');
	 Data_bus <= (others => 'Z');
	 Wr_sig <= '0';
	 Rd_sig <= '0';
	 wait until rst_n = '1';
	 wait for 100 ns;
	 wait until rising_edge(clk);
	 wait for 1 ns;
	end tb_init;

	-- Test Case 1: Konfigurasjon av baud rate og paritet
	procedure config is
	begin
	 Wr_sig <= '1';
	 adresse <= "000";  -- Konfigurer baud rate og paritet
     Data_bus <= "00000001";  -- Sett baud rate til 57600 (001) og ingen paritet (00)
     wait for CLK_PERIOD;
	 Wr_sig <= '0';
     wait for CLK_PERIOD;
	end config;

	procedure send is
	begin
	 Wr_sig <= '1';
	 adresse <= "001"; -- Sender data til Tx
	 Data_bus <= "10101010"; -- data
	 wait for CLK_PERIOD;
	 Wr_sig <= '0';
	 wait for 20*CLK_PERIOD;
     wait for 0.18 ms;
	end send;

    procedure test_busy is
        begin
         Rd_sig <= '1';
         adresse <= "010";  -- Konfigurer Ber om status
         wait for 2*CLK_PERIOD;
         Rd_sig <= '0';
         wait for CLK_PERIOD;
         wait for 0.1 ms;
    end test_busy;
        

    begin
  	tb_init;
	config;
	send;
    test_busy;

	wait for 100 ns;
	assert false report "Testbench finished" severity failure;
    end process;

end architecture SimulationModel;
