
-- Testbench of ctrl
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

-- Entity of testbench (empty)
entity controller_tb is
end controller_tb;

architecture SimulationModel of controller_tb is

    -- Constant declaration
    constant CLK_PERIOD : time := 20 ns;  -- 50 MHz klokke
	
    -- Component declarasion hihi
    component controller
        Port (
            clk, rst_n, msg_key: in std_logic;
        Baud_rate_sel: in std_logic_vector(2 downto 0);
        LED_msg: out std_logic;
        Data_bus : inout std_logic_vector(7 downto 0);
        parity_sel: in std_logic_vector(1 downto 0);
		  adresse: out std_logic_vector(2 downto 0);
		  Rd_sig, Wr_sig: out std_logic
        );
    end component;

    -- Signal declaration
    signal clk      : std_logic := '0';
    signal rst_n    : std_logic := '0';
    signal msg_key  : std_logic := '0';
    signal Baud_rate_sel : std_logic_vector(2 downto 0);
    signal parity_sel : std_logic_vector(1 downto 0);
    signal LED_msg  : std_logic;
    signal adresse  : std_logic_vector(2 downto 0);
    signal Data_bus : std_logic_vector(7 downto 0);
    signal Rd_sig   : std_logic;
    signal Wr_sig   : std_logic;

begin

    -- Component instantiations UART ctrl-modul (DUT)
    DUT: component controller
        Port Map (
            clk         => clk,
            rst_n       => rst_n,
            adresse     => adresse,
            Data_bus    => Data_bus,
            msg_key         => msg_key,
            Baud_rate_sel => Baud_rate_sel,
            parity_sel => parity_sel,
	    Rd_sig      => Rd_sig,
	    Wr_sig	=> Wr_sig
        );

    -- Generation of clock
    p_clk: process is
    begin
        clk <= '0';
        wait for CLK_PERIOD / 2;
        clk <= '1';
        wait for CLK_PERIOD / 2;
    end process;

    --Generation of resetN
    p_rst_n: process is
    begin
      rst_n <= '0';
      wait for 2.2*CLK_PERIOD;
      rst_n <= '1';
      wait;
    end process;

    -- Test procedure
    p_test_procedure: process
        
        -- Initialisation of testbench
        procedure tb_init is
	begin
	 Baud_rate_sel <= "010";
	 parity_sel <= "01";
	 adresse <= "ZZZ";
	 Data_bus <= "ZZZZZZZZ";
	 Wr_sig <= 'Z';
	 Rd_sig <= 'Z';
	 wait until rst_n = '1';
	 wait for 100 ns;
	 wait until rising_edge(clk);

	end tb_init;

	procedure pressButton is
	begin
	 msg_key <= '1';
	 wait for CLK_PERIOD;
	 wait for CLK_PERIOD;
	msg_key <= '0';
	wait for CLK_PERIOD;

     --if Data_bus(7 downto 0) = "01000001" then
     --assert True;
     --else assert false;
    -- end if;
	end pressButton;


    procedure loopAscii is
    begin
	wait for 100 ns;
        adresse(2 downto 0) <= "101";
	wait until rising_edge(clk);
	Data_bus <= "01000001";
	--wait until rising_edge(clk);
        --assert Rd_sig = '1';
        --wait until rising_edge(clk);
        --Data_bus(7 downto 0) <= "01000001";
        --wait until rising_edge(clk);
        --assert adresse(2 downto 0) = "001" report "erra erra pants on fire" severity error;
    end loopAscii;

    begin
  	tb_init;
	pressButton;
    loopAscii;

	wait for 100 ns;
	assert false report "Testbench finished" severity failure;
    end process;

end architecture SimulationModel;