library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


-- Entiteten og signaler inn og ut av den er beskrevet her.

entity Controller is
    Port (
        clk, rst_n, msg_key: in std_logic;
        Baud_rate_sel: in std_logic_vector(2 downto 0);
        LED_msg: out std_logic;
        Data_bus : inout std_logic_vector(7 downto 0);
        parity_sel: in std_logic_vector(1 downto 0);
		  adresse: out std_logic_vector(2 downto 0);
		  Rd_sig, Wr_sig: out std_logic
    );
end Controller;

-- Her begynner arkitekturen, som beskriver logikken. 

architecture RTL of Controller is

    signal internal_baud : std_logic_vector(2 downto 0); -- Internt signal for baud
	 signal internal_parity : std_logic_vector(1 downto 0); -- Internt signal for parity
	 signal turnTaker : std_logic;
	 signal internal_z : std_logic_vector(2 downto 0);
	 signal txBusy : std_logic;
	 type StatusResult is record
    rd_sig_out : std_logic;
    adresse_out : std_logic_vector(2 downto 0);
    turn_taker_out : std_logic;
	 end record;
	 type TxResult is record
    adresse_out : std_logic_vector(2 downto 0);
    data_bus_out : std_logic_vector(7 downto 0);
    wr_sig_out : std_logic;
    rd_sig_out : std_logic;
	 end record;
	 
	procedure resetLogic(
		 signal baud_out : out std_logic_vector(2 downto 0);
		 signal parity_out : out std_logic_vector(1 downto 0)
	) is
	begin
		 case Baud_rate_sel is
			  when "000" => baud_out <= "000";
			  when "001" => baud_out <= "001";
			  when "010" => baud_out <= "010";
			  when "011" => baud_out <= "011";
			  when "100" => baud_out <= "100";
			  when others => baud_out <= "111";
		 end case;

		 case parity_sel is
			  when "00" => parity_out <= "00";
			  when "01" => parity_out <= "01";
			  when "10" => parity_out <= "10";
			  when "11" => parity_out <= "11";
			  when others => parity_out <= "00";
		 end case;
end procedure;
	 
	function statusCheck(turn_taker: std_logic) return StatusResult is
    variable result : StatusResult;
begin
    if turn_taker = '0' then
        result.rd_sig_out := '1';
        result.adresse_out := "010";
        result.turn_taker_out := '1';
    else
        result.rd_sig_out := '1';
        result.adresse_out := "110";
        result.turn_taker_out := '0';
    end if;
    return result;
end function;
	 
	 function getStatusFromRx(databus: std_logic_vector(7 downto 0)) return StatusResult is
    variable result : StatusResult;
begin
    result.rd_sig_out := '1';
    result.adresse_out := "101";
    result.turn_taker_out := '0';  
    return result;
	 end function getStatusFromRx;
	 
	 impure function sendDataToTx(databus: std_logic_vector(7 downto 0)) return TxResult is
    variable result : TxResult;
begin
    if txBusy = '0' then
        result.adresse_out := "001";
        result.data_bus_out := databus;
        result.wr_sig_out := '1';
        result.rd_sig_out := '0';
    else
        result.adresse_out := "ZZZ";  
        result.data_bus_out := databus;
        result.wr_sig_out := '0';
        result.rd_sig_out := '1';
    end if;
    return result;
	 end function sendDataToTx;	 
	 

	 --Arkitekturen begynner
begin

-- prosessen begynner
    
    p_clk : process(clk, rst_n)
	 variable internal_data : std_logic_vector(7 downto 0); 
    variable count : integer := 0;
    variable status_result : StatusResult; 
    variable tx_result : TxResult;   
    begin
	 
	 -- Reset er starten av oppdraget. Her sendes config-informasjon. 
	 if rst_n = '0' then
	 resetLogic(internal_baud, internal_parity);
        
        internal_z <= "000";
        count := 1;
        Data_bus <= internal_z & internal_parity & internal_baud;
        Wr_sig <= '1';
        adresse <= "000";
        elsif rising_edge(clk) then
			  if count = 1 then 
				 internal_z(2 downto 0) <= "000";
				 Data_bus(7 downto 0) <= internal_z & internal_parity & internal_baud;
				 adresse <= "000";
				 Wr_sig <= '1';
				 count := count + 1;
				 elsif count = 2 then
				 internal_z(2 downto 0) <= "110";
				 Data_bus(7 downto 0) <= internal_z & internal_parity & internal_baud;
				 adresse <= "110";
				 Wr_sig <= '1';
				 count := count + 1;
				 else 
				 Wr_sig <= '0';
				 Rd_sig <= '0';
				 Data_bus <= "ZZZZZZZZ";
				 end if;
				 
				
				status_result := statusCheck(turnTaker);
				Rd_sig <= status_result.rd_sig_out;
				adresse <= status_result.adresse_out;
				turnTaker <= status_result.turn_taker_out;
				if Data_bus = "ZZZZZZZZ" then
					Rd_sig <= '0'; 
				elsif Rd_sig = '1' then
					
					tx_result := sendDataToTx(Data_bus);
					adresse <= tx_result.adresse_out;
					Data_bus <= tx_result.data_bus_out;
					Wr_sig <= tx_result.wr_sig_out;
					Rd_sig <= tx_result.rd_sig_out;
				else
					if turnTaker = '1' then -- da skal vi sjekke om TX er busy
						if Data_bus(0 downto 0) = "1" then 
							txBusy <= '1';
					elsif turnTaker = '0' then -- Skal sjekke om Rx har data til oss, status på fifo osv.
						status_result := getStatusFromRx(Data_bus);
						Rd_sig <= status_result.rd_sig_out;
						adresse <= status_result.adresse_out;
						turnTaker <= status_result.turn_taker_out;
						else
					end if;
					end if;
					end if;
		  
		  end if;
		  
	
	
    end process p_clk;

end RTL;
