library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


-- Entiteten og signaler inn og ut av den er beskrevet her.

entity Controller is
    Port (
        clk, rst_n, msg_key: in std_logic;
        Baud_rate_sel: in std_logic_vector(2 downto 0);
        LED_msg: out std_logic;
        Data_bus : inout std_logic_vector(7 downto 0);
        parity_sel: in std_logic_vector(1 downto 0);
		  adresse: out std_logic_vector(2 downto 0);
		  Rd_sig, Wr_sig: inout std_logic
    );
end Controller;

-- Her begynner arkitekturen, som beskriver logikken. 

architecture RTL of Controller is

	--Arkitekturen begynner

begin

-- prosessen begynner

	p_clk : process(clk, rst_n, msg_key, baud_rate_sel, parity_sel)
    begin
		Wr_sig <= '0';
		Rd_sig <= '0';
		LED_msg <= '0';
				
				-- Hvis det ikke er konfigurasjonstid, da gjør vi slik:
        if rising_edge(clk) then
		  
		  -- Reset er starten av oppdraget. Her sendes config-informasjon. 
        if rst_n = '0' then
               case Baud_rate_sel is
					
                when "000" => Data_bus(2 downto 0) <= "000";
					 
                when "001" => Data_bus(2 downto 0) <= "001";
					 
                when "010" => Data_bus(2 downto 0) <= "010";
					 
                when "011" => Data_bus(2 downto 0) <= "011";
					 
                when "100" => Data_bus(2 downto 0) <= "100";
					 
                when others => Data_bus(2 downto 0) <= "111";
            end case;

            case parity_sel is
				
						when "00" => Data_bus(4 downto 3) <= "00"; 
						
						when "01" => Data_bus(4 downto 3) <= "01";
						
						when "10" => Data_bus(4 downto 3) <= "10";
						
						when "11" => Data_bus(4 downto 3) <= "11";
                  when others => Data_bus(4 downto 3) <= "00"; -- Velger dette til default

            end case;
		  
		  
				Data_bus(7 downto 5) <= "ZZZ";
		  	--Sender config info til TX config adresse.
            adresse <= "000";
				Rd_sig <= '0';
            Wr_sig <= '1';
				--Sender config info til RX config adresse.
            adresse <= "100";
				-- Write settes til null. Ingenting skal sendes fra CTRL altså. 
				Wr_sig <='0';
			
				
				else if rst_n = '1' then


			  -- Hvis meldingsknappen trykkes, da sender vi en pre-definert bokstav til TX for videresending. Bokstaven er A.
					if msg_key = '1' then
						 adresse <= "001";
						 Data_bus <= "01000001";
						 Wr_sig <= '1';
						 Wr_sig <= '0';
					end if;
					
					--Hvis RX har mottatt noe data, så skal vi sende videre. Vi skal også skru på led-paeren.

					if adresse = "101" then
						 Rd_sig <= '1';
                   LED_msg <= '1';
						 LED_msg <= '0';
						 adresse <= "001";
                   Wr_sig <= '1'; 
                   Rd_sig <= '0';
						 Wr_sig <= '0';

					end if;
        end if;
		 end if;
		 end if;
    end process p_clk;

end RTL;
