library IEEE;
use IEEE.STD_LOGIC_1164.ALL;

entity project is
    Port (
			clk, rst_n, msg_key: in std_logic;
			Baud_rate_sel: in std_logic_vector(2 downto 0);
			TxD: out std_logic;
			RxD: in std_logic;
			LED_msg: out std_logic;
			parity_sel: in std_logic_vector(1 downto 0)

    );
end project;

architecture UART of project is
    -- Signaldeklarasjoner
signal Data_bus: std_logic_vector(7 downto 0);
signal adresse: std_logic_vector(2 downto 0);
signal Rd_sig, Wr_sig: std_logic;

begin
    -- Instansiering av Controller
    Ctrl: entity work.Controller
        Port map (
            clk           => clk,
            rst_n         => rst_n,
			msg_key		  => msg_key,
            Baud_rate_sel => Baud_rate_sel,
			parity_sel    => parity_sel,
			LED_msg	 	  => LED_msg,
			Data_bus 	  => Data_bus,
            adresse       => adresse,
            Rd_sig        => Rd_sig,
            Wr_sig        => Wr_sig
        );

    -- Instansiering av Tx (Transmitter)
    Tx_Module: entity work.Tx
        Port map (
            clk        => clk,
            rst_n      => rst_n,
            TxD        => TxD,
			Data_bus   => Data_bus,
            adresse    => adresse,
            Rd_sig     => Rd_sig,
            Wr_sig     => Wr_sig
        );

    -- Instansiering av Rx (Receiver)
    Rx_Module: entity work.Rx
        Port map (
            clk        => clk,
            rst_n      => rst_n,
            RxD        => RxD,
			Data_bus   => Data_bus,
            adresse    => adresse,
            Rd_sig     => Rd_sig,
            Wr_sig     => Wr_sig
        );

end architecture UART;