library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


-- Entiteten og signaler inn og ut av den er beskrevet her.

entity Controller is
    Port (
        clk, rst_n, msg_key: in std_logic;
        Baud_rate_sel: in std_logic_vector(2 downto 0);
        LED_msg: out std_logic;
        Data_bus : inout std_logic_vector(7 downto 0);
        parity_sel: in std_logic_vector(1 downto 0);
		  adresse: out std_logic_vector(2 downto 0);
		  Rd_sig, Wr_sig: out std_logic
    );
end Controller;

-- Her begynner arkitekturen, som beskriver logikken

architecture RTL of Controller is

    --signal internal_baud : std_logic_vector(2 downto 0); -- Internt signal for baud
	 --signal internal_parity : std_logic_vector(1 downto 0); -- Internt signal for parity
	 signal turnTaker : std_logic;
	 signal count : integer;
	 signal txBusy : std_logic;
	 signal rxIncomingData: std_logic;
	 type StatusResult is record
    rd_sig_out : std_logic;
	 wr_sig_out : std_logic;
    adresse_out : std_logic_vector(2 downto 0);
    turn_taker_out : std_logic;
	 end record;
	 type TxResult is record
    adresse_out : std_logic_vector(2 downto 0);
    data_bus_out : std_logic_vector(7 downto 0);
    wr_sig_out : std_logic;
    rd_sig_out : std_logic;
	 end record;
	 
	function resetLogic(Baud_rate_sel: std_logic_vector; parity_sel: std_logic_vector)return std_logic_vector is
	 variable baud_out : std_logic_vector(2 downto 0);
	 variable parity_out : std_logic_vector(1 downto 0);
	 variable backbus : std_logic_vector(7 downto 0);
	begin
		 case Baud_rate_sel is
			  when "000" => baud_out := "000";
			  when "001" => baud_out := "001";
			  when "010" => baud_out := "010";
			  when "011" => baud_out := "011";
			  when "100" => baud_out := "100";
			  when others => baud_out := "111";
		 end case;

		 case parity_sel is
			  when "00" => parity_out := "00";
			  when "01" => parity_out := "01";
			  when "10" => parity_out := "10";
			  when "11" => parity_out := "11";
			  when others => parity_out := "00";
		 end case;
		 backbus := "ZZZ" & parity_out & baud_out;
		 return backbus;
end function resetLogic;
	 
	function statusCheck(turn_taker: std_logic) return StatusResult is
    variable result : StatusResult;
begin
    if turn_taker = '0' then -- Hvis det er 0 sin tur, så sjekker vi TX status på neste klokkepuls.
        result.rd_sig_out := '1';
        result.adresse_out := "010";
		  result.wr_sig_out := '0';
        result.turn_taker_out := '1';
    elsif turn_taker = '1' then -- Hvis det er 1 sin tur, da sjekker vi Rx status på neste klokkepuls. 
        result.rd_sig_out := '1';
        result.adresse_out := "110";
		  result.wr_sig_out := '0';
        result.turn_taker_out := '0';
	
    end if;
    return result;
end function;
	 
	 function getStatusFromRx(databus: std_logic_vector(7 downto 0)) return StatusResult is
    variable result : StatusResult;
begin
    result.rd_sig_out := '1';
    result.adresse_out := "101";
    result.turn_taker_out := '0';  
    return result;
	 end function getStatusFromRx;
	 
	 impure function sendDataToTx(databus: std_logic_vector(7 downto 0)) return TxResult is
    variable result : TxResult;
begin
    --if txBusy = '0' then
        result.adresse_out := "001";
        result.data_bus_out := databus;
        result.wr_sig_out := '1';
        result.rd_sig_out := '0';
    --else
     --   result.adresse_out := "ZZZ";  
     --   result.data_bus_out := databus;
     --   result.wr_sig_out := '0';
    --    result.rd_sig_out := '0';
    --end if;
    return result;
	 end function sendDataToTx;	 
	 

	 --Arkitekturen begynner
begin

-- prosessen begynner
    
    p_clk : process(clk, rst_n)
	 variable internal_data : std_logic_vector(7 downto 0); 
    variable status_result : StatusResult; 
    variable tx_result : TxResult;   
    begin
	 
	 -- Reset er starten av oppdraget. Her sendes config-informasjon. 
	 if rst_n = '0' then
        
        Data_bus <= "ZZZZZZZZ";
		  count <= 1;
		  turnTaker <= '0';
		  rxIncomingData <= '0';
		  LED_msg <= '0';
		  Rd_sig <= '0';
		  txBusy <= '0';
        --Data_bus <= internal_z & parity_out & baud_out;
        Wr_sig <= '0';
        adresse <= "000";
        elsif rising_edge(clk) then
		  Data_bus <= "ZZZZZZZZ";
			  if count = 1 then 
				  -- Sender konfigurasjon til TX konfig
				 Data_bus <= resetLogic(Baud_rate_sel, parity_sel);
				 adresse <= "000";
				 Wr_sig <= '1';
				 count <= count + 1;
				 elsif count = 2 then
				  -- Sender konfigurasjon til RX konfig
				  Data_bus <= resetLogic(Baud_rate_sel, parity_sel);
				 adresse <= "100";
				 Wr_sig <= '1';
				 count <= count + 1;
				 elsif count = 3 then
				 
				 if msg_key = '1' then 
					Data_bus <= "01000101";
				   Wr_sig <= '1';
					Rd_sig <= '0';
				   adresse <= "001";
					
					else if rxIncomingData = '1'then 
					
					tx_result := sendDataToTx(Data_bus);
								adresse <= tx_result.adresse_out;
								Data_bus <= tx_result.data_bus_out;
								Wr_sig <= tx_result.wr_sig_out;
								Rd_sig <= '0';
								rxIncomingData <= '0';
					else
					LED_msg <= '0';
				-- normal klokkelogikk. Annahver polling av RX og TX for status.
					status_result := statusCheck(turnTaker);
					Rd_sig <= status_result.rd_sig_out;
					Wr_sig <= status_result.wr_sig_out;
					adresse <= status_result.adresse_out;
					turnTaker <= status_result.turn_taker_out;
						if turnTaker = '0' then -- da skal vi sjekke om TX er busy
							if Data_bus(0 downto 0) = "1" then 
								txBusy <= '1';
								Data_bus <= "ZZZZZZZZ";
							elsif Data_bus(0 downto 0) = "0" then
								txBusy <= '0';
								
							end if;
						elsif turnTaker = '1' then -- Da sjekker på på denne pulsen om Rx har data til oss, status på fifo osv.
							if Data_bus = "ZZZZ0100"then
								
								tx_result := sendDataToTx(Data_bus);
								adresse <= tx_result.adresse_out;
								Data_bus <= tx_result.data_bus_out;
								Wr_sig <= tx_result.wr_sig_out;
								Rd_sig <= '0';
								LED_msg <= '1';
								rxIncomingData <= '0';
							else
							--do nothing
							end if;
					end if;
					end if;
					end if;
					end if;
		  end if;
	
    end process p_clk;

end RTL;
