library IEEE;
use IEEE.STD_LOGIC_1164.ALL;


-- Entiteten og signaler inn og ut av den er beskrevet her.

entity Controller is
    Port (
        clk, rst_n, msg_key: in std_logic;
        Baud_rate_sel: in std_logic_vector(2 downto 0);
        LED_msg: out std_logic;
        Data_bus : inout std_logic_vector(7 downto 0);
        parity_sel: in std_logic_vector(1 downto 0);
		  adresse: out std_logic_vector(2 downto 0);
		  Rd_sig, Wr_sig: out std_logic
    );
end Controller;

-- Her begynner arkitekturen, som beskriver logikken. 

architecture RTL of Controller is

type reader_status is (reading, idle);
    signal status : reader_status := idle;
    signal internal_baud : std_logic_vector(2 downto 0); -- Internal signal for baud
	 signal internal_parity : std_logic_vector(1 downto 0); -- Internt signal for parity
	 signal internal_z : std_logic_vector(2 downto 0);

	 --Arkitekturen begynner
begin

  --  Rd_sig <= '1' when status = reading else '0';
	 
-- prosessen begynner
    
    p_clk : process(clk, rst_n, msg_key, Baud_rate_sel, parity_sel, Data_bus)
    begin
	 
	 -- Reset er starten av oppdraget. Her sendes config-informasjon. 
	 if rst_n = '0' then
                case Baud_rate_sel is
                    when "000" => internal_baud(2 downto 0) <= "000";
                    when "001" => internal_baud(2 downto 0) <= "001";
                    when "010" => internal_baud(2 downto 0) <= "010";
                    when "011" => internal_baud(2 downto 0) <= "011";
                    when "100" => internal_baud(2 downto 0) <= "100";
                    when others => internal_baud(2 downto 0) <= "111";
                end case;

                case parity_sel is
                    when "00" => internal_parity(1 downto 0) <= "00";
                    when "01" => internal_parity(1 downto 0) <= "01";
                    when "10" => internal_parity(1 downto 0) <= "10";
                    when "11" => internal_parity(1 downto 0) <= "11";
                    when others => internal_parity(1 downto 0) <= "00"; -- Default
                end case;
					 
					   internal_z(2 downto 0) <= "000";
						
						Data_bus(7 downto 0) <= internal_z & internal_parity & internal_baud;
						Wr_sig <= '1';
						adresse <= "000";
        elsif rising_edge(clk) then
		  --status <= idle;
		  --Wr_sig <= '0';
		 
			  -- Hvis meldingsknappen trykkes, da sender vi en pre-definert bokstav til TX for videresending.
					if msg_key = '1' then
						 Data_bus <= "01000101";
						 Wr_sig <= '1';
						 adresse <= "001";
						
					end if;
					
					--Hvis RX har mottatt noe data, så skal vi sende videre. Vi skal også skru på led-paeren.

					if adresse = "101" and msg_key = '0' then
						 status <= reading;
                   LED_msg <= '1';
						 adresse <= "001";
                   Wr_sig <= '1'; 
						 --status <= idle;
						 
						 else 
						 Data_bus <= "ZZZZZZZZ";
						 adresse <= "ZZZ";
						 Wr_sig <= '0';
						 Rd_sig <= '0';
						 --status <= idle;
					end if;
        --end if;
		 end if;
    end process p_clk;

end RTL;
