library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity Rx_tb is
end Rx_tb;

architecture Behavioral of Rx_tb is

    -- Testbenkens signaler
    signal clk         : std_logic := '0';
    signal rst_n       : std_logic := '0';
    signal RxD         : std_logic := '1';
    signal Data_bus    : std_logic_vector(7 downto 0) := (others => 'Z');
    signal Rd_sig      : std_logic := '0';
    signal Wr_sig      : std_logic := '0';
    signal adresse     : std_logic_vector(2 downto 0) := "000";

    -- Instans av Rx-komponenten
    component Rx
        generic(
            F_CLK_115k : integer := 54;
            F_CLK_576  : integer := 109;
            F_CLK_384  : integer := 162;
            F_CLK_192  : integer := 325;
            F_CLK_096  : integer := 650
        );
        port(
            clk        : in  std_logic;
            rst_n      : in  std_logic;
            RxD        : in  std_logic;
            Data_bus   : inout std_logic_vector(7 downto 0);
            Rd_sig     : in  std_logic;
            Wr_sig     : in  std_logic;
            adresse    : in  std_logic_vector(2 downto 0)
        );
    end component;

begin

    -- Instansiering av Rx-enheten
    uut: Rx
        port map (
            clk        => clk,
            rst_n      => rst_n,
            RxD        => RxD,
            Data_bus   => Data_bus,
            Rd_sig     => Rd_sig,
            Wr_sig     => Wr_sig,
            adresse    => adresse
        );

    -- Klokkeprosessen genererer et 50 MHz klokkesignal
    clk_process: process
    begin
        while true loop
            clk <= '0';
            wait for 10 ns;
            clk <= '1';
            wait for 10 ns;
        end loop;
    end process;

    -- Stimuli for reset og testoperasjoner
    stimulus: process
    begin
        -- Reset og initiering
        rst_n <= '0';
        wait for 50 ns;
        rst_n <= '1';

        -- Konfigurering av paritetssjekk og baud rate
        adresse <= "100";               -- Adresse for konfigurasjon
        Wr_sig <= '1';                  -- Skriveoperasjon
        Data_bus <= "00001011";         -- Konfigurer for oddetall paritet og baud rate B576
        wait for 20 ns;
        Wr_sig <= '0';
        Data_bus <= (others => 'Z');    -- Sett Data_bus tilbake til Z etter skriving

        -- Test av datastrøm
        wait for 100 ns;
        adresse <= "101";               -- Adresse for lesing av data fra FIFO
        Rd_sig <= '1';
        wait for 20 ns;
        Rd_sig <= '0';

        -- Test av FIFO-status
        wait for 100 ns;
        adresse <= "110";               -- Adresse for lesing av status
        Wr_sig <= '1';
        wait for 20 ns;
        Wr_sig <= '0';

        -- Flere tester kan settes opp her
        -- Slutt på simuleringen
        wait;
    end process;

end Behavioral;
